#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Filter;

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

use Lib::Logger;

my $logger = Lib::Logger->new();

# コンストラクタ
sub new {
    my $self = {};

    use Lib::App::Conf;
    my $conf = Lib::App::Conf->new();

    $self->{system_dir} = $conf->get_system_dir();

    $self->{filterlist} = [];

    bless($self);
    $self->load();
    return $self;
}

# フィルターリストの取得
sub get_filter {
    my $self = shift;
    return @{ $self->{filterlist} };
}

# フィルターリストの取得
sub set_filter {
    my $self = shift;
    @{ $self->{filterlist} } = @_;
}

# フィルターリストの読み込み
sub load {
    my $self = shift;

    my $filterfile = "$self->{system_dir}/filter.txt";
    if (-f $filterfile) {
        my @filterlist = ();
        open my $filterfh, '<', $filterfile;
        while (my $filter = <$filterfh>) {
            chomp($filter);
            if ($filter ne '') {
                push @filterlist, $filter;
            }
        }
        close $filterfh;
        @{ $self->{filterlist} } = @filterlist;
    }
}

# フィルターリストの更新
sub update {
    my $self = shift;

    my $filterfile = "$self->{system_dir}/filter.txt";
    open my $filterfh, '>', $filterfile;
    flock $filterfh, LOCK_EX;
    foreach my $filter (@{ $self->{filterlist} }) {
        print {$filterfh} "$filter\n";
    }
    flock $filterfh, LOCK_UN;
    close $filterfh;

    chmod 0766, $filterfile;
}

# フィルターに登録されていないかチェック
sub check_filter {
    my $self = shift;
    my $text = shift;

#    $logger->write("check_filter - text:$text");  # for debug
    foreach my $filter (@{ $self->{filterlist} }) {
        if ($text =~ /$filter/) {
            return 1;
        }
    }

    return 0;
}

1;
# End of Filter.pm
