#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::DateTime;

use strict;
use warnings;

use Time::Local;

# コンストラクタ
sub new {
    my $self = {};

    $self->{year} = '';
    $self->{month} = '';
    $self->{day} = '';
    $self->{hour} = '';
    $self->{minute} = '';
    $self->{second} = '';

    bless($self);
    return $self;
}

# 年の取得
sub get_year {
    my $self = shift;
    return $self->{year};
}

# 年の設定
sub set_year {
    my $self = shift;
    $self->{year} = shift;
}

# 月の取得
sub get_month {
    my $self = shift;
    return $self->{month};
}

# 月の設定
sub set_month {
    my $self = shift;
    $self->{month} = shift;
}

# 日の取得
sub get_day {
    my $self = shift;
    return $self->{day};
}

# 日の設定
sub set_day {
    my $self = shift;
    $self->{day} = shift;
}

# 時の取得
sub get_hour {
    my $self = shift;
    return $self->{hour};
}

# 時の設定
sub set_hour {
    my $self = shift;
    $self->{hour} = shift;
}

# 分の取得
sub get_minute {
    my $self = shift;
    return $self->{minute};
}

# 分の設定
sub set_minute {
    my $self = shift;
    $self->{minute} = shift;
}

# 秒の取得
sub get_second {
    my $self = shift;
    return $self->{second};
}

# 秒の設定
sub set_second {
    my $self = shift;
    $self->{second} = shift;
}

# 日時の設定
sub set_datetime {
    my $self = shift;
    my $datetime = shift;

    # 日付を設定
    my $date = substr($datetime, 0, 10);
    ($self->{year}, $self->{month}, $self->{day}) = split(/\//, $date);

    # 時刻を設定
    my $time = substr($datetime, 11, 8);
    ($self->{hour}, $self->{minute}, $self->{second}) = split(/:/, $time);
}

# 日時をフォーマットする
# 0:YYYY/MM/DD HH:NN:SS 1:YYYY-MM-DDTHH:NN:SS+09:00 2:YYYY年MM月DD日 HH:NN:SS 3:RFC 822 4:ISO
sub format_datetime {
    my $self = shift;
    my $format = shift;

    my ($year, $month, $day) = ($self->{year}, $self->{month}, $self->{day});
    my ($hour, $minute, $second) = ($self->{hour}, $self->{minute}, $self->{second});

    my $formated_date = '';
    if ($format == 0) {
        $formated_date = "$year/$month/$day $hour:$minute:$second";
    }
    elsif ($format == 1) {
        $formated_date = "$year-$month-$day" . "T$hour:$minute:$second+09:00";
    }
    elsif ($format == 2) {
        $formated_date = "$year年$month月$day日 $hour:$minute:$second";
    }
    elsif ($format == 3) {
        my @weeks = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
        my @months = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
        my ($wday) = (localtime(timelocal(0, 0, 0, $day, $month - 1, $year - 1900)))[6];	# 曜日を求める
        $wday = $weeks[$wday];
        my $mon = $months[$month - 1];
        $formated_date = "$wday, $day $mon $year $hour:$minute:$second +0900";
    }
    elsif ($format == 4) {
        $formated_date = "$year$month$day" . "T$hour:$minute:$second";
    }

    return $formated_date;
}

# ローカル日時の取得
sub local_datetime {
    my $self = shift;
    my ($format) = @_;

    my ($sec, $min, $hour, $mday, $mon, $year) = (localtime(time))[0..5];
    $mon++;
    $year += 1900;

    if ($sec < 10)  { $sec = '0' . $sec; }
    if ($min < 10)  { $min = '0' . $min; }
    if ($hour < 10) { $hour = '0' . $hour; }
    if ($mday < 10) { $mday = '0' . $mday; }
    if ($mon < 10)  { $mon = '0' . $mon; }

    $self->{year} = $year;
    $self->{month} = $mon;
    $self->{day} = $mday;
    $self->{hour} = $hour;
    $self->{minute} = $min;
    $self->{second} = $sec;

    return $self->format_datetime($format);
}

1;
# End of DateTime.pm
