// 極楽画像計測（Gokuraku_measure）用可視化プログラム(Gokuraku_visualizer)
// Created by Tatsuya Shirai
// National Institute of Technology, Suzuka college
// Mechanical Department
//
// Ver. 1.0 : 2022.06.08


Data         data;
ImportFile   im_file;
CurrentImage ci;

ExportFile   ex_file;
ShortMessage shortMessage;

final int Scr_w = 800;
final int Scr_h = 640;

void setup() {
  data         = new Data();
  im_file      = new ImportFile();
  ci           = new CurrentImage();
  ex_file      = new ExportFile();
  shortMessage = new ShortMessage();

  //サイズ変更を許可する
  surface.setResizable(true);

  drop_init();
}

void draw(){
  int x  = 8;
  int y  = 48;
  int dx = 64;
  int dy = 40;

  noStroke();
  if (ci.preview.playing) {
    ci.play(data);
  } else {
    // 画面消去
    surface.setSize(Scr_w, Scr_h);
    fill(72, 72, 72);
//    rect(0, 0, Scr_w - 1, Scr_h - 1);
    background(72, 72, 72);
  
    fill(180, 180, 255);
    // タイトル表示
    textSize(28);
    text("Gokuraku visualizer (@tatsuva) Ver." + Version, x, y); y += dy;
  
    // メニュー表示
    textSize(18);
    text("The data file should be sorted in advance using Excel or other tools.",  x, y); y += dy;
    textSize(24);
    fill(Target_color[ci.target.t_color][0], Target_color[ci.target.t_color][1], Target_color[ci.target.t_color][2]);
    text("[i]",    x, y); text(": import merged data file", x + dx, y); y += dy;
    text("[p]",    x, y); text(": preview images",          x + dx, y); y += dy;
    text("[b]",    x, y); text(": change background color", x + dx, y); y += dy;
    text("[t]",    x, y); text(": change plot type",        x + dx, y); y += dy;
    text("[c]",    x, y); text(": change plot color",       x + dx, y); y += dy;
    text("[l]",    x, y); text(": toggle load image flag ("   + (ci.preview.load_image ? "true" : "false") + ")",  
                                                            x + dx, y); y += dy; 
    text("[s]",    x, y); text(": toggle enable scale flag (" + (ci.preview.enable_scale ? "true" : "false") + ")",  
                                                            x + dx, y); y += dy; 
    text("[f]",    x, y); text(": select folder",           x + dx, y); y += dy;
    text("[e]",    x, y); text(": export image files",      x + dx, y); y += dy;
    text("[ESC]",  x, y); text(": quit",                    x + dx, y); y += dy;
    y += 16;

    textSize(16);
    text("Fileformat: " + ex_file.fullpathname, x, y);              y += 20;
    if (data.num > 0) {
                     text("Imported " + data.num + " files", x, y); y += dy;
    } else {
                     text("Imported no data", x, y);                y += dy;
    }
    shortMessage.display_short_message(x, y);                       y += 20;
  }
}

void keyPressed()
{
  switch (keyCode) {
    case 'i' :
    case 'I' : 
      // 結合されたデータファイルの読み込み
      selectInput("Select a file to process:", "fileSelected");
      break;
    case 'p' :
    case 'P' :
      ci.preview.start_preview();
      break;
    case 'b' :
    case 'B' :
      ci.change_bg();
      shortMessage.set_message("Change background color");
      break;
    case 't' :
    case 'T' :
      ci.target.change_shape();
      shortMessage.set_message("Change target shape");
      break;
    case 'c' :
    case 'C' :
      ci.target.change_color();
      shortMessage.set_message("Change target color");
      break;
    case 'l' :
    case 'L' :
      ci.preview.switch_load_image();
      shortMessage.set_message("Toggled load image : " + (ci.preview.load_image ? "true" : "false"));
      break;
    case 's' :
    case 'S' :
      ci.preview.switch_enable_scale();
      shortMessage.set_message("Toggled enable scale : " + (ci.preview.enable_scale ? "true" : "false"));
      break;
    case 'f' :
    case 'F' :
      // エクスポートするフォルダーの選択
      File fp;
      fp = new File(ex_file.export_folder);
      selectFolder("Select a folder to process:", "folderSelected", fp);
      break;
    case 'e' :
    case 'E' : 
      // 画像ファイルの出力
      ex_file.start_export();
      break;
  }
}

// ファイル選択後の処理
void fileSelected(File selection) 
{
  if (selection == null) return;
  data = im_file.read(selection.getAbsolutePath(), data);
}

// エクスポートするフォルダーの選択
void folderSelected(File selection) {
  if (selection == null) return;  // キャンセル時
  ex_file.export_folder = selection.getAbsolutePath();
  ex_file.set_export_information();
  shortMessage.set_message("User select folder = " + ex_file.export_folder);
}

//// ドラッグ＆ドロップ関係
// 上記URL参照
// ドロップされたファイルの処理
void fileSelected(List<File> fs) {
  for(File f:fs){
    // ドラッグ＆ドロップされたリストの中にフォルダーが含まれていた場合は，その層までは自動的に読み込む
    if (f.isDirectory()) {
      for (File sf:f.listFiles()) {
        if (sf.isFile()) im_file.read(sf.getAbsolutePath(), data);
      }
    } else im_file.read(f.getAbsolutePath(), data);
  }
}

import java.awt.datatransfer.*;  
import java.awt.dnd.*;  
import java.io.File;  
import java.io.IOException;  
import java.awt.Component;
import java.util.List;

DropTarget dropTarget;
Component  component;

void drop_init() {  
  component = (Component)this.surface.getNative();
  dropTarget = new DropTarget(component, new DropTargetListener() {
    public void dragEnter(DropTargetDragEvent dtde) {
    }  
    public void dragOver(DropTargetDragEvent dtde) {
    }  
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }  
    public void dragExit(DropTargetEvent dte) {
    }  
    public void drop(DropTargetDropEvent dtde) {  
      dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);  
      Transferable trans = dtde.getTransferable();  
      List<File> fileNameList = null;  
      if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {  
        try {  
          fileNameList = (List<File>)  
            trans.getTransferData(DataFlavor.javaFileListFlavor);
        } 
        catch (UnsupportedFlavorException ex) {
        } 
        catch (IOException ex) {
        }
      }  
      if (fileNameList == null) return;  
      fileSelected(fileNameList);
    }
  }
  );
}
