//// データ関係のクラス

// Preview関係の再生のコントロール
class Preview {
  boolean playing;
  int     count;
  boolean resized;
  int     delay_time;    // イメージ間の遅れ時間計測用（millis()で差を得る）
  boolean load_image;    // 画像データファイルも読み込むか
  boolean enable_scale;  // 計測時のスケールを有効かするか
  boolean export_enable; // プレビューと同時にexportも実行
  
  void preview() {
    playing       = false;
    resized       = false;
    load_image    = false;
    enable_scale  = false;
    count         = 0;
    export_enable = false;
  }
  // 画像読み込みの無効／有効切り替え
  void switch_load_image() {
    load_image = (load_image ? false : true);
  }
  // スケールの無効／有効切り替え
  void switch_enable_scale() {
    enable_scale = (enable_scale ? false : true);
  }
  // プレビュー開始
  void start_preview() {
    start_preview(false);
  }
  void start_preview(boolean ex) {  // export時は ex = true
    if ((data == null) || (data.num <= 0)) return;  // データが無い
    playing       = true;
    resized       = false;
    count         = 0;
    export_enable = ex;
  }
  void stop_preview() {
    playing       = false;
    count         = 0;
    export_enable = false;
  }
  void next_image() {
    count++;
    resized = false;
  }
  // ディレイタイマーセット
  void set_timer() {
    delay_time = millis();
  }
  // 後処理（主にディレイ）
  void post_process(Data data) {
    int past_time;

    if (! resized) return;
    if (! playing) return;

    past_time = millis() - delay_time;
    if (count + 1 >= data.num) {    // 最後のコマの後
      if (!export_enable) {
        if (past_time < Delay_preview_after) return;
      } else {
        if (past_time < Delay_export_after)  return;
        frameCount = count + 1;
        saveFrame(ex_file.fullpathname);
      }
      stop_preview();
    } else {                        // コマ間
      if (! export_enable) {
        if (past_time < Delay_preview_per_image) return;
      } else {
        if (past_time < Delay_export_per_image)  return;
        frameCount = count + 1;
        saveFrame(ex_file.fullpathname);
      }
      next_image();
    }
    return;
  }
}

// 計測データの可視化に関するクラス
class CurrentImage {
  PImage  img;
  String  fullpathname;            // 開いている画像ファイルのフルパス名
  Preview preview;
  int     bg_color;
  
//  double   scale;                  // 画像の拡大率 ：注意　計測中にも変更できるが，計測精度が落ちる恐れがある．読み込み前に変更するか，再読み込みする
  int      org_width, org_height;  // 画像のオリジナルサイズ
  File[]  files;                   // フォルダーモード：ファイルリスト
  int     f_no;                    // フォルダーモード時の読みだし位置
  int     filter_no;               // -1 : なし，0 : GRAY, 1 : INVERT
  
//  int     _counter;     // 計測済みデータ数

//  PointData []  measured = new PointData[Max_measure];
  TargetMarker  target;
  
  // コンストラクター
  CurrentImage() {
    img          = null;
    fullpathname = null;
    preview      = new Preview();
    bg_color     = 0;
//    scale        = Initial_scale;
    org_width = org_height = -1;
    // フォルダーモード関係
    
    // 計測データ領域の初期化
//    for (_counter = 0; _counter < Max_measure; _counter++) measured[_counter] = new PointData();
    // ターゲットマーカーの初期化
    target = new TargetMarker();
  }
  // １データ１画像を作成
  void renderer(Data data) {
    File   fp;
    PImage img0;
    int    h, w;
    float  scale;
    int    index = preview.count;
    if (data.body[index] == null) return;

    // 元データのサイズを保存
    org_width  = w = data.body[index].org_width;
    org_height = h = data.body[index].org_height;
    scale          = data.body[index].scale;
    if (! preview.resized) {  // 1サイクル目：スクリーンサイズを変更
      // 画像も読み込む場合
      if (preview.load_image) {
        fp = new File("");
        String separator = fp.separator;
        fp = new File(data.src_fullpath + separator + data.body[index].filename);
        img0 = null;
        if (fp.isFile()) {
          if ((img0 = loadImage(fp.getAbsolutePath())) != null) {
            // 読み込み完了
            // 画像を拡大する場合
            if (preview.enable_scale && scale != 1.0) {
              w = (int)(org_width  * scale);
              h = (int)(org_height * scale); 
              img0.resize(w, h);
            }
          }
        }
        img = img0;
      }
      surface.setSize(w, h);
      background(BG_color[bg_color][0], BG_color[bg_color][1], BG_color[bg_color][2]);
      preview.resized = true;
      preview.set_timer();
    } else {                  // ２サイクル目以降：プロットの描画
      // 画像も読み込む場合
      if (preview.load_image) {
        if (img != null) image(img, 0, 0);
      }
      for (int i = 0; i < data.body[index].num; i++) {
        int x = data.body[index].px[i];
        int y = data.body[index].py[i];
        if (preview.enable_scale && (scale != 1.0)) {
          x = (int)(x * scale);
          y = (int)(y * scale);
        }
        target.plot(x, y);
      }
    }
    return;
  }
  // プレビュー
  void play(Data data) {
    if (preview.playing) {
      renderer(data);
      preview.post_process(data);
    }
  }
  // 背景色の変更
  void change_bg() {
    if (++bg_color >= BG_color.length) bg_color = 0; 
    shortMessage.set_message("Change background color to " + bg_color);
  }
/*
  // 画像ファイルの読み込み
  PImage load(String path) {
    boolean reload = false;
    PImage img0;
    if (path == null) reload = true;
    if (! reload) fullpathname = path;
    if ((img0 = loadImage(fullpathname)) == null) return null;  // 読み込み失敗時

    // 読み込み完了
    img = img0;
    println("Loaded image: " + fullpathname);
    // 元画像のサイズを保存
    org_width  = img.width;
    org_height = img.height;
    // 画像を拡大する場合
    if (scale != 1.0) {
      img.resize((int)(img.width * scale), (int)(img.height * scale));
    }
    surface.setSize(img.width, img.height + 40);
    
    if (! reload) _counter  = 0;
    return img;
  }
  // 再読み込み
  PImage reload() {
    if (fullpathname == null) return null;  // 異常な状態
    return load(null);
  }
*/
  
  // 画像の拡大率変更
/*
  void rescale(double rate) {
    double pre_scale = scale;
    if (rate == 0.0) {
      if (scale == Initial_scale) return;                 // 初期値で変更なしの場合
      else                        scale = Initial_scale;  // 初期化
    } else {
      scale *= rate;
//    if (scale < Initial_scale) scale = Initial_scale;
    }
    // 既に計測済みの場合はスケールを変換する
    if (_counter > 0) {
      int n;
      for (n = 0; n < _counter; n++) {
        measured[n].px = (int)(measured[n].px / pre_scale * scale);
        measured[n].py = (int)(measured[n].py / pre_scale * scale);
      }
    }
    println("Change scale " + pre_scale + " -> " + scale);
    reload();  // 画像の再読み込み
  }
*/
}


// 結合されたデータのバッファー
class Data {
  OneData[] body = {};
  String    src_fullpath;  // ファイル名抜きの絶対パス（getParent()）
  private 
  int       num;       // 読み込まれた行数
  // コンストラクター 配列は確保するが，num はstore()ごとに増やしていく
  Data() {
    num          = 0;
    src_fullpath = "";
  }
  // リストを全て削除する
  void allclear() {
    body         = null;
    num          = 0;
    src_fullpath = "";
  }
  // １ファイルのデータをメモリにストア（リストを追加）する
  boolean store(OneData src) {
    OneData d = new OneData();
    body = (OneData [])append(body, d);
    num++;
    return store(body.length - 1, src);
  }
  boolean store(int index, OneData src) {
    if (index > num) return false;
    body[index].filename   = src.filename;
    body[index].org_width  = src.org_width;
    body[index].org_height = src.org_height;
    body[index].scale      = src.scale;
    body[index].num        = src.num;
    for (int i = 0; i < src.px.length; i++) {
      body[index].px = (int [])append(body[index].px, src.px[i]);
      body[index].py = (int [])append(body[index].py, src.py[i]);
    }
    return true;
  }
}

// １ファイル分のデータ
class OneData {  // リスト構造
  String filename;
  int    org_width, org_height;
  float  scale;
  int    num;
  int [] px = {};
  int [] py = {};
  
  // コンストラクター
  OneData() {
    filename   = null;
    org_width  = 0; 
    org_height = 0;
    scale      = 0.0;
  }
  // 座標データを追加する
  boolean append_xy(int x, int y) {
    px = (int [])append(px, x);
    py = (int [])append(py, y);
    if ((px == null) || (py == null)) return false;
    num++;
    return true;
  }
}

//// ファイル関係のクラス
// CSV（タブ区切りの整数）のテキストを整数値に切り分けるクラス
class CsvStrings {
  String text;
  String str;
  float  value;
  // コンストラクター
  CsvStrings(String text) {
    this.set(text);
  }
  void set(String text) {
    this.text = text + "\t";
    value     =  float("NaN");  // floatの形式ではないのでNaNになる
  }
  // 次の値を取得する：正常に終了したらtrueを返し，valueに値が設定される
  boolean next() {
    if (text.indexOf("\t") == -1) return false;
    if (text.length() == 0)       return false;
    if (text.equals("\t"))        return false;
    str   = text.substring(0, text.indexOf("\t"));
    value = float(str);
    text  = text.substring(text.indexOf("\t") + 1);
    return true;
  }
  boolean is_float() {
    if (value != value) return false;  // NaN, ちょっとトリッキーな方法
    return true;
  }
}

// 指定されたデータファイルから１画像分のデータを取得してメモリーに保存するクラス
class ImportFile {
  String fullpathname;
  
  // コンストラクター
  ImportFile() {
    fullpathname = null;
  }

  // ファイル形式のチェック
  boolean validation(String fname) {
    File         fp;
    String[]     lines;  // データファイルから読み出した全テキストデータ
    int          num;    // X,Y座標のデータの組数

    // 読み込めるか？
    if ((lines = loadStrings(fname)) == null) return false;
    // １行はファイル名（ノーチェック），scale, org_width, org_height，num, X座標，Y座標，X座標，Y座標…の繰り返しか？
    for (int i = 0; i < lines.length; i++ ) {
      CsvStrings csv = new CsvStrings(lines[i]);
      csv.next();  // ファイル名
      csv.next();  // scale
      if (! csv.is_float() || csv.value <= 0.0)     return false;  // scale (float)
      csv.next();
      if (! csv.is_float() || int(csv.value) <= 0)  return false;  // org_width (int)
      csv.next();
      if (! csv.is_float() || int(csv.value) <= 0)  return false;  // org_height (int)
      csv.next();
      if (! csv.is_float() || int(csv.value) <= 0)  return false;  // num (int)
      num = int(csv.value);
      // X座標，Y座標の繰り返しのチェック
      for (int j = 0; j < num; j++) {
        if (! csv.next())                             return false;                              
        if (! csv.is_float() || int(csv.value) <= 0)  return false;  // X座標 (int)
        if (! csv.next())                             return false;                              
        if (! csv.is_float() || int(csv.value) <= 0)  return false;  // Y座標 (int)
      }
    }
    return true;
  }
  
  // 実際に統合された出たファイルを読み込む
  Data read(String fname, Data data) {
    CsvStrings   csv;
    String[]     lines;
    OneData      onedata;
    int          num;

    // ファイルチェック
    if (! validation(fname)) return null; 
    // ファイル読み込み
    if ((lines = loadStrings(fname)) == null) return null;
    fullpathname = fname;  // 後で画像をインポートする時にパスを使うかも知れない
    
    data = new Data();

    // 各行のデータを読み込む
    for (int i = 0; i < lines.length; i++) {
      // filename, scale, org_width, org_heightの読み出し
      onedata = new OneData();
      csv     = new CsvStrings(lines[i]);
      csv.next();
      onedata.filename   = csv.str;          // ファイル名
      csv.next();
      onedata.scale      = csv.value;        // scale
      csv.next();
      onedata.org_width  = int(csv.value);   // org_width
      csv.next();
      onedata.org_height = int(csv.value);   // org_height
      csv.next();
      num                = int(csv.value);   // num
  
      // XY座標データの読み込み
      int x, y;
      for (int j = 0; j < num; j++) {
        csv.next(); x = int(csv.value); // X座標
        csv.next(); y = int(csv.value); // Y座標
        onedata.append_xy(x, y);
      }
      // 一行分のデータをメモリーに格納（複製）
      if (! data.store(onedata)) {
        shortMessage.set_message("Error: データのメモリへの格納に失敗しました");
        fullpathname = null;
        return null;
      }
    }
    File fp = new File(fullpathname);
    data.src_fullpath = fp.getParent();  // データファイルの格納されているフォルダーをセット
    // 連番ファイル名のフォーマット用
    ex_file.order10 = int(log(data.num) / log(10)) + 1;

    shortMessage.set_message("Data imported: " + fullpathname + " " + data.num + " lines");
    return data;
  }     
}

// 作成した静止画をファイルに出力するクラス
class ExportFile {
  String      export_folder;  // 動画データを保存する絶対パス
  int         order10;        // 連番画像ファイルの桁数
  String      fullpathname;   // 最終的なフルパス名（saveFrame（）用）
  
  // コンストラクター
  ExportFile() {
    export_folder = sketchPath();
    order10       = 4;  // #### : 0001 - 9999．ファイル読み込み時に自動調整される
    set_export_information();
  }
  void set_export_information() {
    if (order10 < 3) order10 = 3;
    String format = "";
    for (int i = 0; i < order10; i++) format += "#";
    File f = new File(export_folder, Image_filename + format + Image_type);
    fullpathname = f.getAbsolutePath(); 
  }
  void start_export() {
    if (data.num == 0) {
      shortMessage.set_message("Export aborted : No data");
      return;
    }
    ci.preview.start_preview(true);
  }
}

// ターゲットマーカーに関するクラス
class TargetMarker {
  char mode;   // 0: none, 1: cross,  2: circle, 3: poiont
  int  size;
  int  t_color;  // 0, 1, 2
  TargetMarker() {
    mode = 1;
    size = Target_size;
  }
  // ターゲットマーカーの形状を変更
  void change_shape() {
    if (++mode > 3) mode = 0;
  }
  // ターゲットマーカーの色を変更
  void change_color() {
    if (++t_color > Target_color.length - 1) t_color = 0; 
  }
  void plot(int x, int y) {
    stroke(Target_color[t_color][0], Target_color[t_color][1], Target_color[t_color][2]);
    noFill();
    switch (mode) {
      case 0 : break;
      case 1 : line(x - size, y, x + size, y); line(x, y - size, x, y + size); break;
      case 2 : ellipse(x, y, size * 2, size * 2); break;
      case 3 : rectMode(CENTER); rect(x, y, 3, 3); break;
      default : mode = 0;
    }
  }
}


// ウインドウとコンソールエリアに短いメッセージを一時的に表示するためのクラス
class ShortMessage {
private  int    start;
private  String message;
  ShortMessage() {
    start   = millis();
    message = "";
  }
  void set_message(String str) {
    message = str;
    println(str);
    start   = millis();
//  delay(500);          // 連続表示に対応するために．ただし動作が遅くなるため無効にしておくのでご自由に．
  }
  void display_short_message(int x, int y) {
    if (millis() - start < Delay_message) {
      fill(200, 200, 200);
      textSize(16);
      text(message, x, y);
    }
  }
}
