import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.awt.datatransfer.*; 
import java.awt.dnd.*; 
import java.io.File; 
import java.io.IOException; 
import java.awt.Component; 
import java.util.List; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class gokuraku_visualizer extends PApplet {

// 極楽画像計測（Gokuraku_measure）用可視化プログラム(Gokuraku_visualizer)
// Created by Tatsuya Shirai
// National Institute of Technology, Suzuka college
// Mechanical Department
//
// Ver. 1.0 : 2022.06.08


Data         data;
ImportFile   im_file;
CurrentImage ci;

ExportFile   ex_file;
ShortMessage shortMessage;

final int Scr_w = 800;
final int Scr_h = 640;

public void setup() {
  data         = new Data();
  im_file      = new ImportFile();
  ci           = new CurrentImage();
  ex_file      = new ExportFile();
  shortMessage = new ShortMessage();

  //サイズ変更を許可する
  surface.setResizable(true);

  drop_init();
}

public void draw(){
  int x  = 8;
  int y  = 48;
  int dx = 64;
  int dy = 40;

  noStroke();
  if (ci.preview.playing) {
    ci.play(data);
  } else {
    // 画面消去
    surface.setSize(Scr_w, Scr_h);
    fill(72, 72, 72);
//    rect(0, 0, Scr_w - 1, Scr_h - 1);
    background(72, 72, 72);
  
    fill(180, 180, 255);
    // タイトル表示
    textSize(28);
    text("Gokuraku visualizer (@tatsuva) Ver." + Version, x, y); y += dy;
  
    // メニュー表示
    textSize(18);
    text("The data file should be sorted in advance using Excel or other tools.",  x, y); y += dy;
    textSize(24);
    fill(Target_color[ci.target.t_color][0], Target_color[ci.target.t_color][1], Target_color[ci.target.t_color][2]);
    text("[i]",    x, y); text(": import merged data file", x + dx, y); y += dy;
    text("[p]",    x, y); text(": preview images",          x + dx, y); y += dy;
    text("[b]",    x, y); text(": change background color", x + dx, y); y += dy;
    text("[t]",    x, y); text(": change plot type",        x + dx, y); y += dy;
    text("[c]",    x, y); text(": change plot color",       x + dx, y); y += dy;
    text("[l]",    x, y); text(": toggle load image flag ("   + (ci.preview.load_image ? "true" : "false") + ")",  
                                                            x + dx, y); y += dy; 
    text("[s]",    x, y); text(": toggle enable scale flag (" + (ci.preview.enable_scale ? "true" : "false") + ")",  
                                                            x + dx, y); y += dy; 
    text("[f]",    x, y); text(": select folder",           x + dx, y); y += dy;
    text("[e]",    x, y); text(": export image files",      x + dx, y); y += dy;
    text("[ESC]",  x, y); text(": quit",                    x + dx, y); y += dy;
    y += 16;

    textSize(16);
    text("Fileformat: " + ex_file.fullpathname, x, y);              y += 20;
    if (data.num > 0) {
                     text("Imported " + data.num + " files", x, y); y += dy;
    } else {
                     text("Imported no data", x, y);                y += dy;
    }
    shortMessage.display_short_message(x, y);                       y += 20;
  }
}

public void keyPressed()
{
  switch (keyCode) {
    case 'i' :
    case 'I' : 
      // 結合されたデータファイルの読み込み
      selectInput("Select a file to process:", "fileSelected");
      break;
    case 'p' :
    case 'P' :
      ci.preview.start_preview();
      break;
    case 'b' :
    case 'B' :
      ci.change_bg();
      shortMessage.set_message("Change background color");
      break;
    case 't' :
    case 'T' :
      ci.target.change_shape();
      shortMessage.set_message("Change target shape");
      break;
    case 'c' :
    case 'C' :
      ci.target.change_color();
      shortMessage.set_message("Change target color");
      break;
    case 'l' :
    case 'L' :
      ci.preview.switch_load_image();
      shortMessage.set_message("Toggled load image : " + (ci.preview.load_image ? "true" : "false"));
      break;
    case 's' :
    case 'S' :
      ci.preview.switch_enable_scale();
      shortMessage.set_message("Toggled enable scale : " + (ci.preview.enable_scale ? "true" : "false"));
      break;
    case 'f' :
    case 'F' :
      // エクスポートするフォルダーの選択
      File fp;
      fp = new File(ex_file.export_folder);
      selectFolder("Select a folder to process:", "folderSelected", fp);
      break;
    case 'e' :
    case 'E' : 
      // 画像ファイルの出力
      ex_file.start_export();
      break;
  }
}

// ファイル選択後の処理
public void fileSelected(File selection) 
{
  if (selection == null) return;
  data = im_file.read(selection.getAbsolutePath(), data);
}

// エクスポートするフォルダーの選択
public void folderSelected(File selection) {
  if (selection == null) return;  // キャンセル時
  ex_file.export_folder = selection.getAbsolutePath();
  ex_file.set_export_information();
  shortMessage.set_message("User select folder = " + ex_file.export_folder);
}

//// ドラッグ＆ドロップ関係
// 上記URL参照
// ドロップされたファイルの処理
public void fileSelected(List<File> fs) {
  for(File f:fs){
    // ドラッグ＆ドロップされたリストの中にフォルダーが含まれていた場合は，その層までは自動的に読み込む
    if (f.isDirectory()) {
      for (File sf:f.listFiles()) {
        if (sf.isFile()) im_file.read(sf.getAbsolutePath(), data);
      }
    } else im_file.read(f.getAbsolutePath(), data);
  }
}

  
  
  
  



DropTarget dropTarget;
Component  component;

public void drop_init() {  
  component = (Component)this.surface.getNative();
  dropTarget = new DropTarget(component, new DropTargetListener() {
    public void dragEnter(DropTargetDragEvent dtde) {
    }  
    public void dragOver(DropTargetDragEvent dtde) {
    }  
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }  
    public void dragExit(DropTargetEvent dte) {
    }  
    public void drop(DropTargetDropEvent dtde) {  
      dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);  
      Transferable trans = dtde.getTransferable();  
      List<File> fileNameList = null;  
      if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {  
        try {  
          fileNameList = (List<File>)  
            trans.getTransferData(DataFlavor.javaFileListFlavor);
        } 
        catch (UnsupportedFlavorException ex) {
        } 
        catch (IOException ex) {
        }
      }  
      if (fileNameList == null) return;  
      fileSelected(fileNameList);
    }
  }
  );
}
// 定数
final boolean Scale_convert    = true;          // スケールを考慮に入れて座標値を変換するか？（拡大するか）

final int     Target_size      = 5;                 // ターゲットマーカーのサイズ
final int     Target_color[][] = {{255,  80,  80},  // ターゲットマーカーの色 : 赤，白，黒 
                                  {255, 255, 255},
                                  {  0,   0,   0}};
final int     BG_color[][]     = {{255, 255, 255},  // 背景色：白，黒，灰色
                                  {  0,   0,   0},
                                  {128, 128, 128}};
final String  Image_filename   = "merged-";         // 連番ファイル名のヘッド部
final String  Image_type       = ".jpg";            // .tif or .tga or .jpg, or .png 
                                  
// Preveiw関係
final int     Delay_preview_per_image =  500;   // [ms]  // 画像間
final int     Delay_preview_after     = 2000;   // [ms]  // 最後
final int     Delay_export_per_image  =   50;   // [ms]  // 画像間（エクスポート時）
final int     Delay_export_after      =   50;   // [ms]  // 最後（エクスポート時）

final int     Delay_message    = 5000;          // ショートメッセージの表示時間（ミリ秒）

final String  Version          = "2.0"; 
//// データ関係のクラス

// Preview関係の再生のコントロール
class Preview {
  boolean playing;
  int     count;
  boolean resized;
  int     delay_time;    // イメージ間の遅れ時間計測用（millis()で差を得る）
  boolean load_image;    // 画像データファイルも読み込むか
  boolean enable_scale;  // 計測時のスケールを有効かするか
  boolean export_enable; // プレビューと同時にexportも実行
  
  public void preview() {
    playing       = false;
    resized       = false;
    load_image    = false;
    enable_scale  = false;
    count         = 0;
    export_enable = false;
  }
  // 画像読み込みの無効／有効切り替え
  public void switch_load_image() {
    load_image = (load_image ? false : true);
  }
  // スケールの無効／有効切り替え
  public void switch_enable_scale() {
    enable_scale = (enable_scale ? false : true);
  }
  // プレビュー開始
  public void start_preview() {
    start_preview(false);
  }
  public void start_preview(boolean ex) {  // export時は ex = true
    if ((data == null) || (data.num <= 0)) return;  // データが無い
    playing       = true;
    resized       = false;
    count         = 0;
    export_enable = ex;
  }
  public void stop_preview() {
    playing       = false;
    count         = 0;
    export_enable = false;
  }
  public void next_image() {
    count++;
    resized = false;
  }
  // ディレイタイマーセット
  public void set_timer() {
    delay_time = millis();
  }
  // 後処理（主にディレイ）
  public void post_process(Data data) {
    int past_time;

    if (! resized) return;
    if (! playing) return;

    past_time = millis() - delay_time;
    if (count + 1 >= data.num) {    // 最後のコマの後
      if (!export_enable) {
        if (past_time < Delay_preview_after) return;
      } else {
        if (past_time < Delay_export_after)  return;
        frameCount = count + 1;
        saveFrame(ex_file.fullpathname);
      }
      stop_preview();
    } else {                        // コマ間
      if (! export_enable) {
        if (past_time < Delay_preview_per_image) return;
      } else {
        if (past_time < Delay_export_per_image)  return;
        frameCount = count + 1;
        saveFrame(ex_file.fullpathname);
      }
      next_image();
    }
    return;
  }
}

// 計測データの可視化に関するクラス
class CurrentImage {
  PImage  img;
  String  fullpathname;            // 開いている画像ファイルのフルパス名
  Preview preview;
  int     bg_color;
  
//  double   scale;                  // 画像の拡大率 ：注意　計測中にも変更できるが，計測精度が落ちる恐れがある．読み込み前に変更するか，再読み込みする
  int      org_width, org_height;  // 画像のオリジナルサイズ
  File[]  files;                   // フォルダーモード：ファイルリスト
  int     f_no;                    // フォルダーモード時の読みだし位置
  int     filter_no;               // -1 : なし，0 : GRAY, 1 : INVERT
  
//  int     _counter;     // 計測済みデータ数

//  PointData []  measured = new PointData[Max_measure];
  TargetMarker  target;
  
  // コンストラクター
  CurrentImage() {
    img          = null;
    fullpathname = null;
    preview      = new Preview();
    bg_color     = 0;
//    scale        = Initial_scale;
    org_width = org_height = -1;
    // フォルダーモード関係
    
    // 計測データ領域の初期化
//    for (_counter = 0; _counter < Max_measure; _counter++) measured[_counter] = new PointData();
    // ターゲットマーカーの初期化
    target = new TargetMarker();
  }
  // １データ１画像を作成
  public void renderer(Data data) {
    File   fp;
    PImage img0;
    int    h, w;
    float  scale;
    int    index = preview.count;
    if (data.body[index] == null) return;

    // 元データのサイズを保存
    org_width  = w = data.body[index].org_width;
    org_height = h = data.body[index].org_height;
    scale          = data.body[index].scale;
    if (! preview.resized) {  // 1サイクル目：スクリーンサイズを変更
      // 画像も読み込む場合
      if (preview.load_image) {
        fp = new File("");
        String separator = fp.separator;
        fp = new File(data.src_fullpath + separator + data.body[index].filename);
        img0 = null;
        if (fp.isFile()) {
          if ((img0 = loadImage(fp.getAbsolutePath())) != null) {
            // 読み込み完了
            // 画像を拡大する場合
            if (preview.enable_scale && scale != 1.0f) {
              w = (int)(org_width  * scale);
              h = (int)(org_height * scale); 
              img0.resize(w, h);
            }
          }
        }
        img = img0;
      }
      surface.setSize(w, h);
      background(BG_color[bg_color][0], BG_color[bg_color][1], BG_color[bg_color][2]);
      preview.resized = true;
      preview.set_timer();
    } else {                  // ２サイクル目以降：プロットの描画
      // 画像も読み込む場合
      if (preview.load_image) {
        if (img != null) image(img, 0, 0);
      }
      for (int i = 0; i < data.body[index].num; i++) {
        int x = data.body[index].px[i];
        int y = data.body[index].py[i];
        if (preview.enable_scale && (scale != 1.0f)) {
          x = (int)(x * scale);
          y = (int)(y * scale);
        }
        target.plot(x, y);
      }
    }
    return;
  }
  // プレビュー
  public void play(Data data) {
    if (preview.playing) {
      renderer(data);
      preview.post_process(data);
    }
  }
  // 背景色の変更
  public void change_bg() {
    if (++bg_color >= BG_color.length) bg_color = 0; 
    shortMessage.set_message("Change background color to " + bg_color);
  }
/*
  // 画像ファイルの読み込み
  PImage load(String path) {
    boolean reload = false;
    PImage img0;
    if (path == null) reload = true;
    if (! reload) fullpathname = path;
    if ((img0 = loadImage(fullpathname)) == null) return null;  // 読み込み失敗時

    // 読み込み完了
    img = img0;
    println("Loaded image: " + fullpathname);
    // 元画像のサイズを保存
    org_width  = img.width;
    org_height = img.height;
    // 画像を拡大する場合
    if (scale != 1.0) {
      img.resize((int)(img.width * scale), (int)(img.height * scale));
    }
    surface.setSize(img.width, img.height + 40);
    
    if (! reload) _counter  = 0;
    return img;
  }
  // 再読み込み
  PImage reload() {
    if (fullpathname == null) return null;  // 異常な状態
    return load(null);
  }
*/
  
  // 画像の拡大率変更
/*
  void rescale(double rate) {
    double pre_scale = scale;
    if (rate == 0.0) {
      if (scale == Initial_scale) return;                 // 初期値で変更なしの場合
      else                        scale = Initial_scale;  // 初期化
    } else {
      scale *= rate;
//    if (scale < Initial_scale) scale = Initial_scale;
    }
    // 既に計測済みの場合はスケールを変換する
    if (_counter > 0) {
      int n;
      for (n = 0; n < _counter; n++) {
        measured[n].px = (int)(measured[n].px / pre_scale * scale);
        measured[n].py = (int)(measured[n].py / pre_scale * scale);
      }
    }
    println("Change scale " + pre_scale + " -> " + scale);
    reload();  // 画像の再読み込み
  }
*/
}


// 結合されたデータのバッファー
class Data {
  OneData[] body = {};
  String    src_fullpath;  // ファイル名抜きの絶対パス（getParent()）
  private 
  int       num;       // 読み込まれた行数
  // コンストラクター 配列は確保するが，num はstore()ごとに増やしていく
  Data() {
    num          = 0;
    src_fullpath = "";
  }
  // リストを全て削除する
  public void allclear() {
    body         = null;
    num          = 0;
    src_fullpath = "";
  }
  // １ファイルのデータをメモリにストア（リストを追加）する
  public boolean store(OneData src) {
    OneData d = new OneData();
    body = (OneData [])append(body, d);
    num++;
    return store(body.length - 1, src);
  }
  public boolean store(int index, OneData src) {
    if (index > num) return false;
    body[index].filename   = src.filename;
    body[index].org_width  = src.org_width;
    body[index].org_height = src.org_height;
    body[index].scale      = src.scale;
    body[index].num        = src.num;
    for (int i = 0; i < src.px.length; i++) {
      body[index].px = (int [])append(body[index].px, src.px[i]);
      body[index].py = (int [])append(body[index].py, src.py[i]);
    }
    return true;
  }
}

// １ファイル分のデータ
class OneData {  // リスト構造
  String filename;
  int    org_width, org_height;
  float  scale;
  int    num;
  int [] px = {};
  int [] py = {};
  
  // コンストラクター
  OneData() {
    filename   = null;
    org_width  = 0; 
    org_height = 0;
    scale      = 0.0f;
  }
  // 座標データを追加する
  public boolean append_xy(int x, int y) {
    px = (int [])append(px, x);
    py = (int [])append(py, y);
    if ((px == null) || (py == null)) return false;
    num++;
    return true;
  }
}

//// ファイル関係のクラス
// CSV（タブ区切りの整数）のテキストを整数値に切り分けるクラス
class CsvStrings {
  String text;
  String str;
  float  value;
  // コンストラクター
  CsvStrings(String text) {
    this.set(text);
  }
  public void set(String text) {
    this.text = text + "\t";
    value     =  PApplet.parseFloat("NaN");  // floatの形式ではないのでNaNになる
  }
  // 次の値を取得する：正常に終了したらtrueを返し，valueに値が設定される
  public boolean next() {
    if (text.indexOf("\t") == -1) return false;
    if (text.length() == 0)       return false;
    if (text.equals("\t"))        return false;
    str   = text.substring(0, text.indexOf("\t"));
    value = PApplet.parseFloat(str);
    text  = text.substring(text.indexOf("\t") + 1);
    return true;
  }
  public boolean is_float() {
    if (value != value) return false;  // NaN, ちょっとトリッキーな方法
    return true;
  }
}

// 指定されたデータファイルから１画像分のデータを取得してメモリーに保存するクラス
class ImportFile {
  String fullpathname;
  
  // コンストラクター
  ImportFile() {
    fullpathname = null;
  }

  // ファイル形式のチェック
  public boolean validation(String fname) {
    File         fp;
    String[]     lines;  // データファイルから読み出した全テキストデータ
    int          num;    // X,Y座標のデータの組数

    // 読み込めるか？
    if ((lines = loadStrings(fname)) == null) return false;
    // １行はファイル名（ノーチェック），scale, org_width, org_height，num, X座標，Y座標，X座標，Y座標…の繰り返しか？
    for (int i = 0; i < lines.length; i++ ) {
      CsvStrings csv = new CsvStrings(lines[i]);
      csv.next();  // ファイル名
      csv.next();  // scale
      if (! csv.is_float() || csv.value <= 0.0f)     return false;  // scale (float)
      csv.next();
      if (! csv.is_float() || PApplet.parseInt(csv.value) <= 0)  return false;  // org_width (int)
      csv.next();
      if (! csv.is_float() || PApplet.parseInt(csv.value) <= 0)  return false;  // org_height (int)
      csv.next();
      if (! csv.is_float() || PApplet.parseInt(csv.value) <= 0)  return false;  // num (int)
      num = PApplet.parseInt(csv.value);
      // X座標，Y座標の繰り返しのチェック
      for (int j = 0; j < num; j++) {
        if (! csv.next())                             return false;                              
        if (! csv.is_float() || PApplet.parseInt(csv.value) <= 0)  return false;  // X座標 (int)
        if (! csv.next())                             return false;                              
        if (! csv.is_float() || PApplet.parseInt(csv.value) <= 0)  return false;  // Y座標 (int)
      }
    }
    return true;
  }
  
  // 実際に統合された出たファイルを読み込む
  public Data read(String fname, Data data) {
    CsvStrings   csv;
    String[]     lines;
    OneData      onedata;
    int          num;

    // ファイルチェック
    if (! validation(fname)) return null; 
    // ファイル読み込み
    if ((lines = loadStrings(fname)) == null) return null;
    fullpathname = fname;  // 後で画像をインポートする時にパスを使うかも知れない
    
    data = new Data();

    // 各行のデータを読み込む
    for (int i = 0; i < lines.length; i++) {
      // filename, scale, org_width, org_heightの読み出し
      onedata = new OneData();
      csv     = new CsvStrings(lines[i]);
      csv.next();
      onedata.filename   = csv.str;          // ファイル名
      csv.next();
      onedata.scale      = csv.value;        // scale
      csv.next();
      onedata.org_width  = PApplet.parseInt(csv.value);   // org_width
      csv.next();
      onedata.org_height = PApplet.parseInt(csv.value);   // org_height
      csv.next();
      num                = PApplet.parseInt(csv.value);   // num
  
      // XY座標データの読み込み
      int x, y;
      for (int j = 0; j < num; j++) {
        csv.next(); x = PApplet.parseInt(csv.value); // X座標
        csv.next(); y = PApplet.parseInt(csv.value); // Y座標
        onedata.append_xy(x, y);
      }
      // 一行分のデータをメモリーに格納（複製）
      if (! data.store(onedata)) {
        shortMessage.set_message("Error: データのメモリへの格納に失敗しました");
        fullpathname = null;
        return null;
      }
    }
    File fp = new File(fullpathname);
    data.src_fullpath = fp.getParent();  // データファイルの格納されているフォルダーをセット
    // 連番ファイル名のフォーマット用
    ex_file.order10 = PApplet.parseInt(log(data.num) / log(10)) + 1;

    shortMessage.set_message("Data imported: " + fullpathname + " " + data.num + " lines");
    return data;
  }     
}

// 作成した静止画をファイルに出力するクラス
class ExportFile {
  String      export_folder;  // 動画データを保存する絶対パス
  int         order10;        // 連番画像ファイルの桁数
  String      fullpathname;   // 最終的なフルパス名（saveFrame（）用）
  
  // コンストラクター
  ExportFile() {
    export_folder = sketchPath();
    order10       = 4;  // #### : 0001 - 9999．ファイル読み込み時に自動調整される
    set_export_information();
  }
  public void set_export_information() {
    if (order10 < 3) order10 = 3;
    String format = "";
    for (int i = 0; i < order10; i++) format += "#";
    File f = new File(export_folder, Image_filename + format + Image_type);
    fullpathname = f.getAbsolutePath(); 
  }
  public void start_export() {
    if (data.num == 0) {
      shortMessage.set_message("Export aborted : No data");
      return;
    }
    ci.preview.start_preview(true);
  }
}

// ターゲットマーカーに関するクラス
class TargetMarker {
  char mode;   // 0: none, 1: cross,  2: circle, 3: poiont
  int  size;
  int  t_color;  // 0, 1, 2
  TargetMarker() {
    mode = 1;
    size = Target_size;
  }
  // ターゲットマーカーの形状を変更
  public void change_shape() {
    if (++mode > 3) mode = 0;
  }
  // ターゲットマーカーの色を変更
  public void change_color() {
    if (++t_color > Target_color.length - 1) t_color = 0; 
  }
  public void plot(int x, int y) {
    stroke(Target_color[t_color][0], Target_color[t_color][1], Target_color[t_color][2]);
    noFill();
    switch (mode) {
      case 0 : break;
      case 1 : line(x - size, y, x + size, y); line(x, y - size, x, y + size); break;
      case 2 : ellipse(x, y, size * 2, size * 2); break;
      case 3 : rectMode(CENTER); rect(x, y, 3, 3); break;
      default : mode = 0;
    }
  }
}


// ウインドウとコンソールエリアに短いメッセージを一時的に表示するためのクラス
class ShortMessage {
private  int    start;
private  String message;
  ShortMessage() {
    start   = millis();
    message = "";
  }
  public void set_message(String str) {
    message = str;
    println(str);
    start   = millis();
//  delay(500);          // 連続表示に対応するために．ただし動作が遅くなるため無効にしておくのでご自由に．
  }
  public void display_short_message(int x, int y) {
    if (millis() - start < Delay_message) {
      fill(200, 200, 200);
      textSize(16);
      text(message, x, y);
    }
  }
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "gokuraku_visualizer" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
