/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import processing.core.PApplet;
import processing.core.PImage;

public class gokuraku_visualizer
extends PApplet {
    Data data;
    ImportFile im_file;
    CurrentImage ci;
    ExportFile ex_file;
    ShortMessage shortMessage;
    final int Scr_w = 800;
    final int Scr_h = 640;
    DropTarget dropTarget;
    Component component;
    final boolean Scale_convert = true;
    final int Target_size = 5;
    final int[][] Target_color = new int[][]{{255, 80, 80}, {255, 255, 255}, new int[3]};
    final int[][] BG_color = new int[][]{{255, 255, 255}, new int[3], {128, 128, 128}};
    final String Image_filename = "merged-";
    final String Image_type = ".jpg";
    final int Delay_preview_per_image = 500;
    final int Delay_preview_after = 2000;
    final int Delay_export_per_image = 50;
    final int Delay_export_after = 50;
    final int Delay_message = 5000;
    final String Version = "2.0";

    public void setup() {
        this.data = new Data();
        this.im_file = new ImportFile();
        this.ci = new CurrentImage();
        this.ex_file = new ExportFile();
        this.shortMessage = new ShortMessage();
        this.surface.setResizable(true);
        this.drop_init();
    }

    public void draw() {
        int x = 8;
        int y = 48;
        int dx = 64;
        int dy = 40;
        this.noStroke();
        if (this.ci.preview.playing) {
            this.ci.play(this.data);
        } else {
            this.surface.setSize(800, 640);
            this.fill(72.0f, 72.0f, 72.0f);
            this.background(72.0f, 72.0f, 72.0f);
            this.fill(180.0f, 180.0f, 255.0f);
            this.textSize(28.0f);
            this.text("Gokuraku visualizer (@tatsuva) Ver.2.0", x, y);
            this.textSize(18.0f);
            this.text("The data file should be sorted in advance using Excel or other tools.", x, y += dy);
            this.textSize(24.0f);
            this.fill(this.Target_color[this.ci.target.t_color][0], this.Target_color[this.ci.target.t_color][1], this.Target_color[this.ci.target.t_color][2]);
            this.text("[i]", x, y += dy);
            this.text(": import merged data file", x + dx, y);
            this.text("[p]", x, y += dy);
            this.text(": preview images", x + dx, y);
            this.text("[b]", x, y += dy);
            this.text(": change background color", x + dx, y);
            this.text("[t]", x, y += dy);
            this.text(": change plot type", x + dx, y);
            this.text("[c]", x, y += dy);
            this.text(": change plot color", x + dx, y);
            this.text("[l]", x, y += dy);
            this.text(": toggle load image flag (" + (this.ci.preview.load_image ? "true" : "false") + ")", x + dx, y);
            this.text("[s]", x, y += dy);
            this.text(": toggle enable scale flag (" + (this.ci.preview.enable_scale ? "true" : "false") + ")", x + dx, y);
            this.text("[f]", x, y += dy);
            this.text(": select folder", x + dx, y);
            this.text("[e]", x, y += dy);
            this.text(": export image files", x + dx, y);
            this.text("[ESC]", x, y += dy);
            this.text(": quit", x + dx, y);
            y += dy;
            this.textSize(16.0f);
            this.text("Fileformat: " + this.ex_file.fullpathname, x, y += 16);
            y += 20;
            if (this.data.num > 0) {
                this.text("Imported " + this.data.num + " files", x, y);
                y += dy;
            } else {
                this.text("Imported no data", x, y);
                y += dy;
            }
            this.shortMessage.display_short_message(x, y);
            y += 20;
        }
    }

    public void keyPressed() {
        switch (this.keyCode) {
            case 73: 
            case 105: {
                this.selectInput("Select a file to process:", "fileSelected");
                break;
            }
            case 80: 
            case 112: {
                this.ci.preview.start_preview();
                break;
            }
            case 66: 
            case 98: {
                this.ci.change_bg();
                this.shortMessage.set_message("Change background color");
                break;
            }
            case 84: 
            case 116: {
                this.ci.target.change_shape();
                this.shortMessage.set_message("Change target shape");
                break;
            }
            case 67: 
            case 99: {
                this.ci.target.change_color();
                this.shortMessage.set_message("Change target color");
                break;
            }
            case 76: 
            case 108: {
                this.ci.preview.switch_load_image();
                this.shortMessage.set_message("Toggled load image : " + (this.ci.preview.load_image ? "true" : "false"));
                break;
            }
            case 83: 
            case 115: {
                this.ci.preview.switch_enable_scale();
                this.shortMessage.set_message("Toggled enable scale : " + (this.ci.preview.enable_scale ? "true" : "false"));
                break;
            }
            case 70: 
            case 102: {
                File fp = new File(this.ex_file.export_folder);
                this.selectFolder("Select a folder to process:", "folderSelected", fp);
                break;
            }
            case 69: 
            case 101: {
                this.ex_file.start_export();
            }
        }
    }

    public void fileSelected(File selection) {
        if (selection == null) {
            return;
        }
        this.data = this.im_file.read(selection.getAbsolutePath(), this.data);
    }

    public void folderSelected(File selection) {
        if (selection == null) {
            return;
        }
        this.ex_file.export_folder = selection.getAbsolutePath();
        this.ex_file.set_export_information();
        this.shortMessage.set_message("User select folder = " + this.ex_file.export_folder);
    }

    public void fileSelected(List<File> fs) {
        for (File f : fs) {
            if (f.isDirectory()) {
                File[] fileArray = f.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File sf = fileArray[n2];
                    if (sf.isFile()) {
                        this.im_file.read(sf.getAbsolutePath(), this.data);
                    }
                    ++n2;
                }
                continue;
            }
            this.im_file.read(f.getAbsolutePath(), this.data);
        }
    }

    public void drop_init() {
        this.component = (Component)this.surface.getNative();
        this.dropTarget = new DropTarget(this.component, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(3);
                Transferable trans = dtde.getTransferable();
                List fileNameList = null;
                if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        fileNameList = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {}
                }
                if (fileNameList == null) {
                    return;
                }
                gokuraku_visualizer.this.fileSelected(fileNameList);
            }
        });
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"gokuraku_visualizer"};
        if (passedArgs != null) {
            PApplet.main((String[])gokuraku_visualizer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class CsvStrings {
        String text;
        String str;
        float value;

        CsvStrings(String text) {
            this.set(text);
        }

        public void set(String text) {
            this.text = String.valueOf(text) + "\t";
            this.value = PApplet.parseFloat((String)"NaN");
        }

        public boolean next() {
            if (this.text.indexOf("\t") == -1) {
                return false;
            }
            if (this.text.length() == 0) {
                return false;
            }
            if (this.text.equals("\t")) {
                return false;
            }
            this.str = this.text.substring(0, this.text.indexOf("\t"));
            this.value = PApplet.parseFloat((String)this.str);
            this.text = this.text.substring(this.text.indexOf("\t") + 1);
            return true;
        }

        public boolean is_float() {
            return this.value == this.value;
        }
    }

    class CurrentImage {
        PImage img = null;
        String fullpathname = null;
        Preview preview;
        int bg_color;
        int org_width;
        int org_height;
        File[] files;
        int f_no;
        int filter_no;
        TargetMarker target;

        CurrentImage() {
            this.preview = new Preview();
            this.bg_color = 0;
            this.org_height = -1;
            this.org_width = -1;
            this.target = new TargetMarker();
        }

        public void renderer(Data data) {
            int h;
            int w;
            int index = this.preview.count;
            if (data.body[index] == null) {
                return;
            }
            this.org_width = w = data.body[index].org_width;
            this.org_height = h = data.body[index].org_height;
            float scale = data.body[index].scale;
            if (!this.preview.resized) {
                if (this.preview.load_image) {
                    File fp = new File("");
                    String separator = File.separator;
                    fp = new File(String.valueOf(data.src_fullpath) + separator + data.body[index].filename);
                    PImage img0 = null;
                    if (fp.isFile() && (img0 = gokuraku_visualizer.this.loadImage(fp.getAbsolutePath())) != null && this.preview.enable_scale && scale != 1.0f) {
                        w = (int)((float)this.org_width * scale);
                        h = (int)((float)this.org_height * scale);
                        img0.resize(w, h);
                    }
                    this.img = img0;
                }
                gokuraku_visualizer.this.surface.setSize(w, h);
                gokuraku_visualizer.this.background(gokuraku_visualizer.this.BG_color[this.bg_color][0], gokuraku_visualizer.this.BG_color[this.bg_color][1], gokuraku_visualizer.this.BG_color[this.bg_color][2]);
                this.preview.resized = true;
                this.preview.set_timer();
            } else {
                if (this.preview.load_image && this.img != null) {
                    gokuraku_visualizer.this.image(this.img, 0.0f, 0.0f);
                }
                int i = 0;
                while (i < data.body[index].num) {
                    int x = data.body[index].px[i];
                    int y = data.body[index].py[i];
                    if (this.preview.enable_scale && scale != 1.0f) {
                        x = (int)((float)x * scale);
                        y = (int)((float)y * scale);
                    }
                    this.target.plot(x, y);
                    ++i;
                }
            }
        }

        public void play(Data data) {
            if (this.preview.playing) {
                this.renderer(data);
                this.preview.post_process(data);
            }
        }

        public void change_bg() {
            if (++this.bg_color >= gokuraku_visualizer.this.BG_color.length) {
                this.bg_color = 0;
            }
            gokuraku_visualizer.this.shortMessage.set_message("Change background color to " + this.bg_color);
        }
    }

    class Data {
        OneData[] body = new OneData[0];
        String src_fullpath = "";
        private int num = 0;

        Data() {
        }

        public void allclear() {
            this.body = null;
            this.num = 0;
            this.src_fullpath = "";
        }

        public boolean store(OneData src) {
            OneData d = new OneData();
            this.body = (OneData[])gokuraku_visualizer.append((Object)this.body, (Object)d);
            ++this.num;
            return this.store(this.body.length - 1, src);
        }

        public boolean store(int index, OneData src) {
            if (index > this.num) {
                return false;
            }
            this.body[index].filename = src.filename;
            this.body[index].org_width = src.org_width;
            this.body[index].org_height = src.org_height;
            this.body[index].scale = src.scale;
            this.body[index].num = src.num;
            int i = 0;
            while (i < src.px.length) {
                this.body[index].px = gokuraku_visualizer.append((int[])this.body[index].px, (int)src.px[i]);
                this.body[index].py = gokuraku_visualizer.append((int[])this.body[index].py, (int)src.py[i]);
                ++i;
            }
            return true;
        }
    }

    class ExportFile {
        String export_folder;
        int order10;
        String fullpathname;

        ExportFile() {
            this.export_folder = gokuraku_visualizer.this.sketchPath();
            this.order10 = 4;
            this.set_export_information();
        }

        public void set_export_information() {
            if (this.order10 < 3) {
                this.order10 = 3;
            }
            String format = "";
            int i = 0;
            while (i < this.order10) {
                format = String.valueOf(format) + "#";
                ++i;
            }
            File f = new File(this.export_folder, "merged-" + format + ".jpg");
            this.fullpathname = f.getAbsolutePath();
        }

        public void start_export() {
            if (gokuraku_visualizer.this.data.num == 0) {
                gokuraku_visualizer.this.shortMessage.set_message("Export aborted : No data");
                return;
            }
            gokuraku_visualizer.this.ci.preview.start_preview(true);
        }
    }

    class ImportFile {
        String fullpathname = null;

        ImportFile() {
        }

        public boolean validation(String fname) {
            String[] lines = gokuraku_visualizer.this.loadStrings(fname);
            if (lines == null) {
                return false;
            }
            int i = 0;
            while (i < lines.length) {
                CsvStrings csv = new CsvStrings(lines[i]);
                csv.next();
                csv.next();
                if (!csv.is_float() || csv.value <= 0.0f) {
                    return false;
                }
                csv.next();
                if (!csv.is_float() || PApplet.parseInt((float)csv.value) <= 0) {
                    return false;
                }
                csv.next();
                if (!csv.is_float() || PApplet.parseInt((float)csv.value) <= 0) {
                    return false;
                }
                csv.next();
                if (!csv.is_float() || PApplet.parseInt((float)csv.value) <= 0) {
                    return false;
                }
                int num = PApplet.parseInt((float)csv.value);
                int j = 0;
                while (j < num) {
                    if (!csv.next()) {
                        return false;
                    }
                    if (!csv.is_float() || PApplet.parseInt((float)csv.value) <= 0) {
                        return false;
                    }
                    if (!csv.next()) {
                        return false;
                    }
                    if (!csv.is_float() || PApplet.parseInt((float)csv.value) <= 0) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }

        public Data read(String fname, Data data) {
            if (!this.validation(fname)) {
                return null;
            }
            String[] lines = gokuraku_visualizer.this.loadStrings(fname);
            if (lines == null) {
                return null;
            }
            this.fullpathname = fname;
            data = new Data();
            int i = 0;
            while (i < lines.length) {
                OneData onedata = new OneData();
                CsvStrings csv = new CsvStrings(lines[i]);
                csv.next();
                onedata.filename = csv.str;
                csv.next();
                onedata.scale = csv.value;
                csv.next();
                onedata.org_width = PApplet.parseInt((float)csv.value);
                csv.next();
                onedata.org_height = PApplet.parseInt((float)csv.value);
                csv.next();
                int num = PApplet.parseInt((float)csv.value);
                int j = 0;
                while (j < num) {
                    csv.next();
                    int x = PApplet.parseInt((float)csv.value);
                    csv.next();
                    int y = PApplet.parseInt((float)csv.value);
                    onedata.append_xy(x, y);
                    ++j;
                }
                if (!data.store(onedata)) {
                    gokuraku_visualizer.this.shortMessage.set_message("Error: \u30c7\u30fc\u30bf\u306e\u30e1\u30e2\u30ea\u3078\u306e\u683c\u7d0d\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                    this.fullpathname = null;
                    return null;
                }
                ++i;
            }
            File fp = new File(this.fullpathname);
            data.src_fullpath = fp.getParent();
            gokuraku_visualizer.this.ex_file.order10 = PApplet.parseInt((float)(gokuraku_visualizer.log((float)data.num) / gokuraku_visualizer.log((float)10.0f))) + 1;
            gokuraku_visualizer.this.shortMessage.set_message("Data imported: " + this.fullpathname + " " + data.num + " lines");
            return data;
        }
    }

    class OneData {
        String filename = null;
        int org_width = 0;
        int org_height = 0;
        float scale = 0.0f;
        int num;
        int[] px = new int[0];
        int[] py = new int[0];

        OneData() {
        }

        public boolean append_xy(int x, int y) {
            this.px = gokuraku_visualizer.append((int[])this.px, (int)x);
            this.py = gokuraku_visualizer.append((int[])this.py, (int)y);
            if (this.px == null || this.py == null) {
                return false;
            }
            ++this.num;
            return true;
        }
    }

    class Preview {
        boolean playing;
        int count;
        boolean resized;
        int delay_time;
        boolean load_image;
        boolean enable_scale;
        boolean export_enable;

        Preview() {
        }

        public void preview() {
            this.playing = false;
            this.resized = false;
            this.load_image = false;
            this.enable_scale = false;
            this.count = 0;
            this.export_enable = false;
        }

        public void switch_load_image() {
            this.load_image = !this.load_image;
        }

        public void switch_enable_scale() {
            this.enable_scale = !this.enable_scale;
        }

        public void start_preview() {
            this.start_preview(false);
        }

        public void start_preview(boolean ex) {
            if (gokuraku_visualizer.this.data == null || gokuraku_visualizer.this.data.num <= 0) {
                return;
            }
            this.playing = true;
            this.resized = false;
            this.count = 0;
            this.export_enable = ex;
        }

        public void stop_preview() {
            this.playing = false;
            this.count = 0;
            this.export_enable = false;
        }

        public void next_image() {
            ++this.count;
            this.resized = false;
        }

        public void set_timer() {
            this.delay_time = gokuraku_visualizer.this.millis();
        }

        public void post_process(Data data) {
            if (!this.resized) {
                return;
            }
            if (!this.playing) {
                return;
            }
            int past_time = gokuraku_visualizer.this.millis() - this.delay_time;
            if (this.count + 1 >= data.num) {
                if (!this.export_enable) {
                    if (past_time < 2000) {
                        return;
                    }
                } else {
                    if (past_time < 50) {
                        return;
                    }
                    gokuraku_visualizer.this.frameCount = this.count + 1;
                    gokuraku_visualizer.this.saveFrame(gokuraku_visualizer.this.ex_file.fullpathname);
                }
                this.stop_preview();
            } else {
                if (!this.export_enable) {
                    if (past_time < 500) {
                        return;
                    }
                } else {
                    if (past_time < 50) {
                        return;
                    }
                    gokuraku_visualizer.this.frameCount = this.count + 1;
                    gokuraku_visualizer.this.saveFrame(gokuraku_visualizer.this.ex_file.fullpathname);
                }
                this.next_image();
            }
        }
    }

    class ShortMessage {
        private int start;
        private String message;

        ShortMessage() {
            this.start = gokuraku_visualizer.this.millis();
            this.message = "";
        }

        public void set_message(String str) {
            this.message = str;
            gokuraku_visualizer.println((String)str);
            this.start = gokuraku_visualizer.this.millis();
        }

        public void display_short_message(int x, int y) {
            if (gokuraku_visualizer.this.millis() - this.start < 5000) {
                gokuraku_visualizer.this.fill(200.0f, 200.0f, 200.0f);
                gokuraku_visualizer.this.textSize(16.0f);
                gokuraku_visualizer.this.text(this.message, x, y);
            }
        }
    }

    class TargetMarker {
        char mode = '\u0001';
        int size = 5;
        int t_color;

        TargetMarker() {
        }

        public void change_shape() {
            this.mode = (char)(this.mode + '\u0001');
            if (this.mode > '\u0003') {
                this.mode = '\u0000';
            }
        }

        public void change_color() {
            if (++this.t_color > gokuraku_visualizer.this.Target_color.length - 1) {
                this.t_color = 0;
            }
        }

        public void plot(int x, int y) {
            gokuraku_visualizer.this.stroke(gokuraku_visualizer.this.Target_color[this.t_color][0], gokuraku_visualizer.this.Target_color[this.t_color][1], gokuraku_visualizer.this.Target_color[this.t_color][2]);
            gokuraku_visualizer.this.noFill();
            switch (this.mode) {
                case '\u0000': {
                    break;
                }
                case '\u0001': {
                    gokuraku_visualizer.this.line(x - this.size, y, x + this.size, y);
                    gokuraku_visualizer.this.line(x, y - this.size, x, y + this.size);
                    break;
                }
                case '\u0002': {
                    gokuraku_visualizer.this.ellipse(x, y, this.size * 2, this.size * 2);
                    break;
                }
                case '\u0003': {
                    gokuraku_visualizer.this.rectMode(3);
                    gokuraku_visualizer.this.rect(x, y, 3.0f, 3.0f);
                    break;
                }
                default: {
                    this.mode = '\u0000';
                }
            }
        }
    }
}

