/*
 * Decompiled with CFR 0.152.
 */
package org.ginkgo.gcov.navigator;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class CoverageLabelProvider
extends OwnerDrawLabelProvider {
    private TreeViewerColumn column;
    private TreeViewer viewer;

    public CoverageLabelProvider(TreeViewerColumn column2, TreeViewer commonViewer) {
        this.column = column2;
        this.viewer = commonViewer;
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        int totalLine = 133;
        int coverLine = 20;
        int offset = 2;
        float coverage = 0.0f;
        GC gc = event.gc;
        if (element instanceof ICElement) {
            ICElement a = (ICElement)element;
            try {
                IProject p = a.getCProject().getProject();
                String n = a.getElementName();
                totalLine = Integer.parseInt(p.getPersistentProperty(new QualifiedName(n, "totalLine")));
                coverage = Float.parseFloat(p.getPersistentProperty(new QualifiedName(n, "persent")));
                coverLine = (int)((float)totalLine * coverage / 100.0f);
            }
            catch (NumberFormatException numberFormatException) {
                coverLine = 0;
                return;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
        String str = String.format("%6.2f %% [ %3d / %3d ]", Float.valueOf(coverage), coverLine, totalLine);
        Display disp = this.viewer.getControl().getDisplay();
        Rectangle rect = new Rectangle(event.x, event.y + 1 + gc.textExtent((String)str).y, this.column.getColumn().getWidth(), event.height);
        rect = this.drawBevelRect(gc, rect, disp.getSystemColor(18), disp.getSystemColor(20));
        this.drawCoverRect(gc, rect, (int)coverage, disp.getSystemColor(5));
        this.drawUnCoverRect(gc, rect, (int)coverage, disp.getSystemColor(3));
        gc.drawText(str, event.x + 1, event.y + offset, true);
    }

    private Rectangle drawBevelRect(GC gc, Rectangle rect, Color normalShadow, Color highlightShadow) {
        Color fg = gc.getForeground();
        Rectangle insideRect = new Rectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        gc.setForeground(normalShadow);
        gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
        gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
        gc.setForeground(highlightShadow);
        gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
        gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        gc.setForeground(fg);
        return insideRect;
    }

    private void drawUnCoverRect(GC gc, Rectangle rect, int coverage, Color color) {
        Color bg = gc.getBackground();
        gc.setBackground(color);
        int w = rect.width * coverage / 100;
        gc.fillRectangle(rect.x + w, rect.y, rect.width - w, rect.height);
        gc.setBackground(bg);
    }

    private void drawCoverRect(GC gc, Rectangle rect, int coverage, Color color) {
        Color bg = gc.getBackground();
        gc.setBackground(color);
        gc.setBackground(color);
        int w = rect.width * coverage / 100;
        gc.fillRectangle(rect.x, rect.y, w, rect.height);
        gc.setBackground(bg);
    }
}

