/** @file
 */
#if !defined(__GDESTRAIER__MODEL__FILETYPE__HPP__)
#define __GDESTRAIER__MODEL__FILETYPE__HPP__

#include <string>
#include <vector>
#include <boost/noncopyable.hpp>

namespace gdestraier {

  namespace model {

    class filetype : public boost::noncopyable {
    protected:
      char const*   name_;

      filetype();  // DON'T IMPLEMENT

    public:
      filetype(char const* name) :
        name_(name)
      {
      }
      ~filetype() { }

    public:
      char const* get_name() const { return name_; }
      char const* get_translated() const;

    public:
      static filetype const   auto_;
      static filetype const   document_draft_;
      static filetype const   plain_text_;
      static filetype const   html_;
      //static filetype const   mime_;
#if defined(HAVE_LIBID3)
      static filetype const   mp3_;
#endif
      static filetype const   pdf_;
      static filetype const   excel_;
      static filetype const   powerpoint_;
    };



    class filetypes_manager :
      public boost::noncopyable {
    protected:
      filetypes_manager();
      ~filetypes_manager();

      typedef std::vector<filetype const*> filetypes_type;
      filetypes_type filetypes_;

    public:
      typedef filetypes_type::const_iterator iterator;

    public:
      static filetypes_manager& instance();

      inline iterator begin() const { return filetypes_.begin(); }
      inline iterator end() const { return filetypes_.end(); }

      filetype const* find(char const* name) const;
    };

  }

}

#endif
