/** @file
 */
#if !defined(__GDESTRAIER__GLADE_HELPER__HPP__)
#define __GDESTRAIER__GLADE_HELPER__HPP__

#include <glade/glade-xml.h>
#include <gtkmm/widget.h>
#include <gtkmm/button.h>
#include <gtkmm/menuitem.h>
#include <sigc++/slot.h>

#include <boost/static_assert.hpp>
#include <boost/type_traits/is_pointer.hpp>
#include <boost/type_traits/remove_pointer.hpp>

namespace gdestraier {
  namespace gui {

    ::GladeXML* load_glade_xml(char const* root);
    Gtk::Widget* load_toplevel_widget(char const* name);


    template <typename T_Widget_PtrPtr>
    void load_toplevel_widget_derived(char const* name, T_Widget_PtrPtr widget)
    {
      typedef typename boost::remove_pointer<T_Widget_PtrPtr>::type T_Widget_Ptr;
      typedef typename boost::remove_pointer<T_Widget_Ptr>::type T_Widget;
      typedef typename T_Widget::BaseObjectType cwidget_type;

      *widget = 0;
      ::GladeXML* glade = load_glade_xml(name);
      ::GtkWidget* w = ::glade_xml_get_widget(glade, name);
      cwidget_type* cw = G_TYPE_CHECK_INSTANCE_CAST(w, T_Widget::get_base_type(), cwidget_type);

      if (! cw)
        g_critical("glade-helper::get_widget_derived: G_TYPE_CHECK_INSTANCE_CAST failed.");
      else if (Glib::ObjectBase::_get_current_wrapper((GObject*)cw)) {
        *widget = dynamic_cast<T_Widget*>(Glib::wrap((cwidget_type*)cw) );
        if (! *widget)
          g_critical("glade-helper::get_widget_derived: dynamic_cast failed.");
      } else
          *widget = new T_Widget(cw, glade);

      ::g_object_unref(G_OBJECT(glade));
    }




    template <typename T_Widget_PtrPtr>
    inline void load_toplevel_widget_derived(T_Widget_PtrPtr widget)
    {
      typedef typename boost::remove_pointer<T_Widget_PtrPtr>::type T_Widget_Ptr;
      typedef typename boost::remove_pointer<T_Widget_Ptr>::type T_Widget;

      load_toplevel_widget_derived<T_Widget_PtrPtr>(T_Widget::get_glade_node_name(), widget);
    }



    template <typename T_Widget_PtrPtr>
    inline void get_widget(::GladeXML* glade, char const* name, T_Widget_PtrPtr widget) {
      typedef typename boost::remove_pointer<T_Widget_PtrPtr>::type T_Widget_Ptr;
      typedef typename boost::remove_pointer<T_Widget_Ptr>::type T_Widget;
      typedef typename T_Widget::BaseObjectType cwidget_type;

      *widget = 0;
      ::GtkWidget* w = ::glade_xml_get_widget(glade, name);
      cwidget_type* cw = G_TYPE_CHECK_INSTANCE_CAST(w, T_Widget::get_base_type(), cwidget_type );
      *widget = Glib::wrap(cw, false);
    }


    template <typename T_Widget_PtrPtr>
    inline void get_widget_derived(::GladeXML* glade, char const* name, T_Widget_PtrPtr widget) {
      typedef typename boost::remove_pointer<T_Widget_PtrPtr>::type T_Widget_Ptr;
      typedef typename boost::remove_pointer<T_Widget_Ptr>::type T_Widget;
      typedef typename T_Widget::BaseObjectType cwidget_type;

      *widget = 0;
      ::GtkWidget* w = ::glade_xml_get_widget(glade, name);
      cwidget_type* cw = G_TYPE_CHECK_INSTANCE_CAST(w, T_Widget::get_base_type(), cwidget_type );

      if (! cw)
        g_critical("glade-helper::get_widget_derived: G_TYPE_CHECK_INSTANCE_CAST failed.");
      else if (Glib::ObjectBase::_get_current_wrapper((GObject*)cw)) {
        *widget = dynamic_cast<T_Widget*>(Glib::wrap((cwidget_type*)cw) );
        if (! *widget)
          g_critical("glade-helper::get_widget_derived: dynamic_cast failed.");
      } else
          *widget = new T_Widget(cw, glade);
    }


    void connect_clicked(::GladeXML* glade, char const* name, sigc::slot<void> const& slot);
  }
}

#endif
