/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Constants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PaletteListener
implements Listener {
    private Point offset;
    private Composite composite;
    private Point mouseDownPoint;
    private Point initSize;

    public PaletteListener(Composite composite) {
        this.composite = composite;
    }

    public void handleEvent(Event event) {
        try {
            if (this.composite.isDisposed()) {
                return;
            }
            Rectangle rect = this.composite.getBounds();
            switch (event.type) {
                case 3: {
                    if (rect.contains(event.x, event.y)) {
                        this.offset = new Point(this.composite.getLocation().x - event.x, this.composite.getLocation().y - event.y);
                        this.composite.moveAbove(null);
                        this.mouseDownPoint = new Point(event.x, event.y);
                        this.initSize = this.composite.getSize();
                        if (event.button == 1) {
                            this.composite.getParent().setCursor(Constants.CURSOR_MOVE);
                            break;
                        }
                        if (event.button == 3) {
                            this.composite.getParent().setCursor(Constants.CURSOR_RESIZE);
                        }
                    }
                    break;
                }
                case 5: {
                    if (this.offset == null) {
                        return;
                    }
                    if (event.stateMask == 524288) {
                        this.composite.setLocation(event.x + this.offset.x, event.y + this.offset.y);
                        Composite base = this.composite.getParent();
                        ScrolledComposite scrollComposite = (ScrolledComposite)base.getParent();
                        scrollComposite.setMinSize(base.computeSize(-1, -1));
                        break;
                    }
                    if (event.stateMask == 0x200000) {
                        int distX = this.mouseDownPoint.x - event.x;
                        int distY = this.mouseDownPoint.y - event.y;
                        this.composite.setSize(new Point(this.initSize.x - distX, this.initSize.y - distY));
                    }
                    break;
                }
                case 4: {
                    this.offset = null;
                    if (this.composite.isEnabled()) break;
                    this.composite.getParent().setCursor(Constants.CURSOR_HAND);
                }
                default: {
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

