/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.Constants;
import com.hisagisoft.eclipse.gadgetholder.GadgetHolderManager;
import com.hisagisoft.eclipse.gadgetholder.StructTitle;
import com.hisagisoft.eclipse.gadgetholder.actions.BackwardAction;
import com.hisagisoft.eclipse.gadgetholder.actions.ForwardAction;
import com.hisagisoft.eclipse.gadgetholder.actions.ImportAction;
import com.hisagisoft.eclipse.gadgetholder.actions.NewAction;
import com.hisagisoft.eclipse.gadgetholder.actions.RemoveAllAction;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.InputForm;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class GadgetView
extends ViewPart {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private CTabFolder folder;
    private GadgetHolderManager manager;
    private GadgetList gadgets;
    private Action forwardAction;
    private Action backwardAction;
    private Action refreshAction;
    private Action newAction;
    private Action removeAction;
    private Action removeAllAction;
    private Action saveAction;
    private Action rollbackAction;
    private Action importAction;
    private Action exportAction;
    private StructTitle title;
    private ImageRegistry imageRegistry;

    public void createPartControl(Composite parent) {
        this.imageRegistry = Activator.getDefault().getImageRegistry();
        this.title = new StructTitle();
        this.title.put(StructTitle.Key.TITLE, this.getPartName());
        this.title.put(StructTitle.Key.UNSAVED, "");
        this.logger.fine("title = " + this.title);
        this.setPartName(this.title.toString());
        this.folder = new CTabFolder(parent, 0);
        this.manager = GadgetHolderManager.getInstance();
        this.manager.setGadgetView(this);
        this.gadgets = this.manager.getGadgets();
        for (Gadget gadget : this.gadgets) {
            this.addBrowser(gadget);
        }
        this.makeActions();
        this.setEnabledActions();
    }

    public void addBrowser(Gadget gadget) {
        assert (gadget != null && this.folder != null);
        CTabItem item = new CTabItem(this.folder, 0);
        if (gadget.isNew()) {
            item.setImage(this.imageRegistry.get("IMG_OBJ_NEW"));
        } else {
            item.setImage(this.imageRegistry.get("IMG_OBJ_FILE"));
        }
        this.folder.setSelection(item);
        Browser browser = new Browser((Composite)this.folder, 0);
        browser.setUrl(gadget.getFile().getAbsolutePath());
        item.setControl((Control)browser);
        item.setData(Gadget.class.getName(), (Object)gadget);
    }

    public void disposeSelectedTab() {
        CTabItem item = this.folder.getSelection();
        if (item != null) {
            if (item.getControl() != null) {
                item.getControl().dispose();
            }
            item.dispose();
        }
    }

    public void openInputFormTab() {
        CTabItem item = new CTabItem(this.folder, 0);
        item.setImage(this.imageRegistry.get("IMG_OBJ_NEW"));
        this.folder.setSelection(item);
        InputForm inputForm = new InputForm((Composite)this.folder, 0);
        item.setControl((Control)inputForm);
        inputForm.setFocus();
    }

    private void makeActions() {
        this.newAction = new NewAction();
        this.forwardAction = new ForwardAction();
        this.backwardAction = new BackwardAction();
        this.refreshAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("REFRESH Action");
                    Control control = GadgetView.this.folder.getSelection().getControl();
                    if (control instanceof Browser) {
                        Browser b = (Browser)control;
                        b.refresh();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.refreshAction.setToolTipText("\u66f4\u65b0");
        this.refreshAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_REFRESH"));
        this.refreshAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_REFRESH_DISABLED"));
        this.removeAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("REMOVE Action");
                    CTabItem item = GadgetView.this.folder.getSelection();
                    Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
                    GadgetView.this.logger.info("remove gadget.id = " + gadget.getId());
                    gadget.setRemoved(true);
                    item.setImage(GadgetView.this.imageRegistry.get("IMG_OBJ_REMOVED"));
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.removeAction.setToolTipText("\u524a\u9664");
        this.removeAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_REMOVE"));
        this.removeAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_REMOVE_DISABLED"));
        this.removeAllAction = new RemoveAllAction();
        this.saveAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("SAVE Action");
                    GadgetView.this.gadgets.commit();
                    GadgetView.this.manager.saveProperties();
                    GadgetView.this.updateView();
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.saveAction.setToolTipText("\u4fdd\u5b58");
        this.saveAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_SAVE"));
        this.saveAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_SAVE_DISABLED"));
        this.rollbackAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("ROLLBACK Action");
                    GadgetView.this.gadgets.rollback();
                    GadgetView.this.updateView();
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.rollbackAction.setToolTipText("\u3084\u308a\u76f4\u3057");
        this.rollbackAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_ROLLBACK"));
        this.rollbackAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_ROLLBACK_DISABLED"));
        this.importAction = new ImportAction();
        this.exportAction = new Action(){

            public void run() {
                try {
                    boolean ok;
                    GadgetView.this.logger.fine("EXPORT Action");
                    FileDialog fd = new FileDialog(GadgetView.this.folder.getShell());
                    fd.setFileName("export.html");
                    fd.setFilterExtensions(new String[]{"*.html"});
                    fd.setFilterPath(Constants.PATH_MY_DOCUMENTS);
                    String filePath = fd.open();
                    if (filePath == null) {
                        return;
                    }
                    File file = new File(filePath);
                    if (file.exists() && !(ok = MessageDialog.openConfirm((Shell)GadgetView.this.folder.getShell(), (String)"Confirm", (String)"File already exists. Overwrite?"))) {
                        GadgetView.this.logger.fine("CANCEL");
                        return;
                    }
                    GadgetView.this.manager.exportGadget(file);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.exportAction.setToolTipText("\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.exportAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT"));
        this.exportAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT_DISABLED"));
        IToolBarManager bars = this.getViewSite().getActionBars().getToolBarManager();
        bars.add((IContributionItem)new Separator());
        bars.add((IAction)this.backwardAction);
        bars.add((IAction)this.forwardAction);
        bars.add((IContributionItem)new Separator());
        bars.add((IAction)this.refreshAction);
        bars.add((IContributionItem)new Separator());
        bars.add((IAction)this.newAction);
        bars.add((IAction)this.removeAction);
        bars.add((IAction)this.removeAllAction);
        bars.add((IContributionItem)new Separator());
        bars.add((IAction)this.saveAction);
        bars.add((IAction)this.rollbackAction);
        bars.add((IContributionItem)new Separator());
        bars.add((IAction)this.importAction);
        bars.add((IAction)this.exportAction);
    }

    public void setEnabledActions() {
        assert (this.newAction != null && this.forwardAction != null && this.backwardAction != null && this.removeAction != null && this.removeAllAction != null && this.saveAction != null && this.rollbackAction != null && this.importAction != null && this.exportAction != null);
        this.newAction.setEnabled(true);
        this.importAction.setEnabled(true);
        if (this.gadgets.size() > 0) {
            this.refreshAction.setEnabled(true);
            this.removeAction.setEnabled(true);
            this.removeAllAction.setEnabled(true);
            this.exportAction.setEnabled(true);
        } else {
            this.refreshAction.setEnabled(false);
            this.removeAction.setEnabled(false);
            this.removeAllAction.setEnabled(false);
            this.exportAction.setEnabled(false);
        }
        if (this.gadgets.size() > 1) {
            this.forwardAction.setEnabled(true);
            this.backwardAction.setEnabled(true);
        } else {
            this.forwardAction.setEnabled(false);
            this.backwardAction.setEnabled(false);
        }
        if (this.gadgets.isModified()) {
            this.saveAction.setEnabled(true);
            this.rollbackAction.setEnabled(true);
            this.title.put(StructTitle.Key.UNSAVED, "*");
        } else {
            this.saveAction.setEnabled(false);
            this.rollbackAction.setEnabled(false);
            this.title.put(StructTitle.Key.UNSAVED, "");
        }
        this.setPartName(this.title.toString());
    }

    private void updateView() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
            if (gadget.isRemoved()) {
                item.getControl().dispose();
                item.dispose();
            } else if (gadget.isNew()) {
                item.dispose();
            } else {
                item.setImage(this.imageRegistry.get("IMG_OBJ_FILE"));
            }
            ++n2;
        }
    }

    public void updateItemIcon() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
            if (gadget.isRemoved()) {
                item.setImage(this.imageRegistry.get("IMG_OBJ_REMOVED"));
            } else if (gadget.isNew()) {
                item.setImage(this.imageRegistry.get("IMG_OBJ_NEW"));
            } else {
                item.setImage(this.imageRegistry.get("IMG_OBJ_FILE"));
            }
            ++n2;
        }
    }

    public void setFocus() {
    }

    public void changeNextTab() {
        int count;
        if (this.folder.getSelection() == null) {
            return;
        }
        int current = this.folder.getSelectionIndex();
        if (current == (count = this.folder.getItemCount()) - 1) {
            this.folder.setSelection(0);
        } else {
            this.folder.setSelection(current + 1);
        }
    }

    public void changePrevTab() {
        if (this.folder.getSelection() == null) {
            return;
        }
        int current = this.folder.getSelectionIndex();
        int count = this.folder.getItemCount();
        if (current == 0) {
            this.folder.setSelection(count - 1);
        } else {
            this.folder.setSelection(current - 1);
        }
    }
}

