#pragma once

#include <string>
#include <exception>

#include "Logger.hpp"


/*!
 * [ŰUɊւO
 */
class CImpersonateUserException
	: public std::exception
{
private:
	DWORD errcode_;

public:
	CImpersonateUserException(DWORD errorcode)
		: errcode_(errorcode)
	{
	}

	DWORD GetErrorCode() const
	{
		return errcode_;
	}
};


/*!
 * OI[UU܂B
 */
class CImpersonateUser
{
private:

	/*!
	 * [Ũg[N
	 */
	HANDLE userToken_;

	/*!
	 * Uł邩?
	 */
	bool bImpersonate_;

	/*!
	 * K[
	 */
	Logger *pLogger_;

	/*!
	 * [U
	 */
	tstring user_;

	/*!
	 * hC
	 */
	tstring domain_;

public:

	CImpersonateUser();

	/*!
	 * UĂ΋UAOIĂ΃OIt܂B
	 * łȂΉ܂B
	 */
	~CImpersonateUser() throw();

	/*!
	 * K[ݒ肵܂B
	 * NULL̏ꍇ̓K[܂B
	 * \param pLogger K[ANULL
	 */
	void SetLogger(Logger *pLogger) throw()
	{
		pLogger_ = pLogger;
	}

	Logger* GetLogger() const
	{
		return pLogger_;
	}

	/*!
	 * OI܂B
	 * łɃOIĂĂ͂Ȃ܂B
	 * OCɎsꍇCImpersonateUserExceptionO܂B
	 * \param userName [U
	 * \param domain hCA
	 * \param password pX[hA
	 */
	void logon(const tstring& userName, const tstring& domain, const tstring& password);

	/*!
	 * U܂B
	 * łɋUĂĂ͂Ȃ܂B
	 * sꍇCImpersonateUserExceptionO܂B
	 */
	void impersonate() ;

	/*!
	 * U܂B
	 * OIĂȂAUĂȂΉAfalseԂ܂B
	 * ̏ꍇGetLastError()NO_ERRORԂ܂B
	 * UɐꍇtrueԂ܂B
	 * UłȂꍇfalseԂAGetLastError()ŃG[R[h擾ł܂B
	 * \return UꂽꍇtrueAUĂȂAɎsꍇfalse
	 */
	bool revertToSelf() throw();

	/*!
	 * OIt܂B
	 * OCĂȂΉ܂B
	 * UĂꍇ͋U܂B
	 * OItꂽꍇtrueԂ܂B
	 * OItłȂꍇfalseԂAGetLastError()ŃG[R[h擾ł܂B
	 * \return OIĂȂAOItꂽꍇtrueBOItłȂꍇfalse
	 */
	bool logoff() throw();
};
