#pragma once

#include "ObjectReaderWriter.hpp"

#include <string>


class CFileInfo
{
private:
	tstring name_;
	FILETIME writetime_;
	DWORD attributes_;
	unsigned __int64 size_;

	bool bExist_;
	bool detectModified_;
	FILETIME detectBegin_;

	bool deletePending_;
	FILETIME deletePendingBegin_;

	DWORD runCount_;


public:
	/*!
	 * VACYp
	 */
	CFileInfo(); 

	CFileInfo(const WIN32_FIND_DATA& v_finddata, bool v_modified, bool v_exists = true);
	
	CFileInfo(const CFileInfo& v_other);

	CFileInfo& operator=( const CFileInfo& v_other);

	~CFileInfo();

	/*!
	 * t@C̍ŏIXVAꂪΎɖOő召r܂B
	 * \param other rΏ
	 * \return ΕA0Aΐ
	 */
	int compare(const CFileInfo& other) const;

	/*!
	 * t@Cۑ܂B
	 */
	void Save(CObjectWriter& writer) const;

	/*!
	 * t@C𕜌܂B
	 */
	void Load(CObjectReader& reader);


	inline const tstring& getFileName() const
	{
		return name_;
	}

	inline const FILETIME& getLastModified() const
	{
		return writetime_;
	}

	inline unsigned __int64 getSize() const
	{
		return size_;
	}

	inline DWORD getAttribute() const
	{
		return attributes_;
	}


	inline bool isExist() const
	{
		return bExist_;
	}

	inline bool isDeletePending() const
	{
		return deletePending_;
	}

	inline const FILETIME& getDeletePendingBegin() const
	{
		return deletePendingBegin_;
	}

	inline bool isDetectModified() const
	{
		return detectModified_;
	}

	inline const FILETIME& getDetectBegin() const
	{
		return detectBegin_;
	}

	inline DWORD getRunCount() const
	{
		return runCount_;
	}



	bool update(const WIN32_FIND_DATA& v_finddata);


	void setSize(unsigned __int64 v_size);

	void setExist(bool v_exist);

	void setFileName(const tstring& v_fileName);

	void setLastModified(const FILETIME& v_filetime);

	void setAttributes(DWORD attributes);

	void setDeletePending(bool v_deletePending);

	void setDeletePendingBegin(const FILETIME &ftNow);

	void setDetectModified(bool v_detectModified);

	void setDetectBegin(const FILETIME& ftNow);


	void incrementRunCount();

	void setRunCount(DWORD v_runCount);


	/*!
	 * ff(O)p
	 */
	tstring str() const;

	/*!
	 * WIN32_FIND_DATÃt@CTCY64rbgȂ擾܂B
	 * \param v_finddata ʏ
	 * \return t@CTCY(64rbg)
	 */
	static unsigned __int64 GetFileSize(const WIN32_FIND_DATA& v_finddata);
};
