#include "stdafx.h"
#include "FWatchApp.hpp"
#include "resource.h"

#include "FWatchVersionDlg.hpp"

#include <shellapi.h>

#include <vector>

#pragma comment(lib, "Version.lib")
#pragma comment(lib, "shell32.lib")

FWatchVersionDlg::FWatchVersionDlg()
{
}

FWatchVersionDlg::~FWatchVersionDlg()
{
}

void FWatchVersionDlg::show(HWND hWnd)
{
	::DialogBoxParam(
		app.getInstanceHandle(),
		(LPCTSTR) IDD_ABOUTBOX,
		hWnd,
		(DLGPROC) DlgProc,
		(LPARAM) this
		);
}

BOOL FWatchVersionDlg::OnInitDialog()
{
	TCHAR szModuleFileName[MAX_PATH] = {0};
	::GetModuleFileName(NULL, szModuleFileName, MAX_PATH);

	DWORD siz = ::GetFileVersionInfoSize(szModuleFileName, 0);
	if (siz > 0) {
		std::vector<unsigned char> buf(siz + 1);
		LPVOID pBuf = &buf[0];

		if (::GetFileVersionInfo(szModuleFileName, 0, siz, pBuf)) {

			LPCTSTR strFileVersion = NULL;
			LPCTSTR strLegalCopyright = NULL;
			LPCTSTR strComments = NULL;

			UINT lenFileVersion = 0;
			UINT lenLegalCopyright = 0;
			UINT lenComments;
			
			VerQueryValue(pBuf, _T("\\StringFileInfo\\041104b0\\FileVersion" ),
				(LPVOID*) &strFileVersion, &lenFileVersion);
			VerQueryValue(pBuf, _T("\\StringFileInfo\\041104b0\\LegalCopyright" ),
				(LPVOID*) &strLegalCopyright, &lenLegalCopyright);
			VerQueryValue(pBuf, _T("\\StringFileInfo\\041104b0\\Comments" ),
				(LPVOID*) &strComments, &lenComments);
			
			assert(strFileVersion != NULL && "t@Co[W擾ł܂B");
			assert(strLegalCopyright != NULL && "Rs[Cg擾ł܂B");
			assert(strComments != NULL && "Rg擾ł܂B");

			HWND hAppName = GetDlgItem(hDlg_, IDC_ABOUT_APPNAME);
			HWND hCopyright = GetDlgItem(hDlg_, IDC_ABOUT_COPYRIGHT);
			HWND hVersion = GetDlgItem(hDlg_, IDC_ABOUT_VERSION);

			assert(hAppName && "AvP[V\x̃EBhEnhNULLłB");
			assert(hCopyright && "Rs[Cg\x̃EBhEnhNULLłB");
			assert(hVersion && "o[W\x̃EBhEnhNULLłB");

			SetWindowText(hAppName, strComments);
			SetWindowText(hCopyright, strLegalCopyright);
			SetWindowText(hVersion, strFileVersion);
		}
	}

	return TRUE;
}

// o[W{bNXpbZ[W nh
LRESULT CALLBACK FWatchVersionDlg::DlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	FWatchVersionDlg* me = (FWatchVersionDlg*) ::GetWindowLongPtr(hDlg, DWLP_USER);
	assert((me == NULL || me->hDlg_ == hDlg) && "QƂsłB");

	switch (message)
	{
	case WM_INITDIALOG:
		{
			me = (FWatchVersionDlg*) lParam;
			assert(me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B");
			::SetWindowLongPtr(hDlg, DWLP_USER, (LONG) me);
			me->hDlg_ = hDlg;
			return me->OnInitDialog();
		}

	case WM_COMMAND:
		{
			const UINT uID = LOWORD(wParam);
			switch (uID)
			{
			case IDOK:
			case IDCANCEL:
				EndDialog(hDlg, uID);
				break;

			case IDC_HOMEPAGE:
				{
					const tstring url = app.LoadString(IDS_PROJECT_HOMEPAGE);
					::ShellExecute(NULL, _T("OPEN"), url.c_str(), NULL, NULL, SW_SHOWNORMAL);
				}
				break;

			default:
				return FALSE;
			}
		}
		return TRUE;
	}
    return FALSE;
}
