#pragma once

#include "SettingInfo.hpp"

#include <string>
#include <map>
#include <list>
#include <functional>

#include "FileInfo.hpp"
#include "NameMatcher.hpp"
#include "ImpersonateUser.hpp"
#include "ActionInvoker.hpp"
#include "Logger.hpp"

/*!
 * t@C̃^CX^vł邩肷֐IuWFNg
 */
class FileTimeComparator
	: public std::binary_function<FILETIME, FILETIME, bool>
{
private:
	long tolerance_;

public:
	FileTimeComparator(long v_tolerance)
		: tolerance_(v_tolerance)
	{
	}

	inline bool operator()(const FILETIME& a, const FILETIME& b) const
	{
		const __int64& t1 = *(__int64*) &a;
		const __int64& t2 = *(__int64*) &b;
		const __int64 distance = (t2 - t1) / 10000;
		return !((distance < -tolerance_) || (distance > tolerance_));
	}
};


/*!
 * ~Cxgɂ銄荞ݗpO
 */
class CWatchThreadInterruptedException : public std::exception
{
public:
	static void checkAndThrow(HANDLE hStopEvent);
};


/*!
 * 1̐ݒɑ΂ĎsĎ{(Xbh)B
 */
class CWatchThread
{
private:
	CWatchThread(const CWatchThread&); //<! Ȃ
	CWatchThread& operator=(const CWatchThread&); //<! Ȃ

private:

	typedef std::map<tstring, CFileInfo> CFileInfoMap;

	CFileInfoMap fileInfoMap_;

	typedef std::list<tstring> FileNameList;

	FileNameList pendingList_;

	LoggerPtr pLogger_;

	ActionInvokerPtr pActionInvoker_;

	const FileTimeComparator fileTimeComparator_;

	CSettingInfo settingInfo_;

	HANDLE hStopEvent_;

	HANDLE hThread_;

	DWORD nThreadID_;


	DWORD spanSweepDeletedEntries_;

	DWORD spanHeapCompaction_;

	DWORD spanSavePersist_;

	DWORD baseCycle_;

	DWORD nResetRunCount_;

	bool bContinueWhenFailedImpersonate_;

	bool bRevertToSelfOnAction_;

	bool bPersistAtForceInterval_;

	CNameMatcher nameMatcher_;

	tstring persist_;

public:

	CWatchThread(const CSettingInfo& v_settingInfo);

	virtual ~CWatchThread();

	const CSettingInfo& getSettingInfo() const;

	/*!
	 * XbhJn܂B
	 * łɃXbhJnς݂łΉ܂B
	 */
	void Start();

	/*!
	 * ~vMXbh̒~҂܂B
	 * \[X邽߁AƂStop()ĂяoKv܂B
	 */
	void StopNoWait();

	/*!
	 * Xbh~܂B
	 * Xbh~܂őҋ@܂B
	 * łɒ~ĂΉ܂B
	 */
	void Stop();

	/*!
	 * Xbhsł邩肵܂B
	 * \return słtrue
	 */
	bool isRunning() const;

private:

	/*!
	 * XbhvV[W
	 */
	static unsigned __stdcall ThreadProc(void* pParam);

	/*!
	 * Xbh̃C[v
	 */
	void run();

	/*!
	 * 폜\̃GĝAP\Ԃ߂GgB
	 * 폜ꂽGg̐Ԃ܂B
	 * \param ftNow ݎ
	 * \param bSkipDeletePending 폜\t@CȂꍇtrueɐݒ肳B
	 * \return 폜ꂽGg̐
	 */
	int sweepDeletedEntries(const FILETIME &ftNow, bool &bSkipDeletePending);

	/*!
	 * ĎfBNg𑖍܂B
	 * v_enableEventtrueł΁Aǉ܂͍XVɂm҂tOĂ܂B
	 * falsȅꍇ̓GgǉEXVE폜邾Ŋm҂͔܂B
	 * ǉEύXE폜ꂽGg̐Ԃ܂B
	 * \param ftNow ݓ
	 * \param v_enableEvent m҂tOĂꍇtrue
	 * \return ǉEύXE폜ꂽGg̐
	 */
	int EnumFile(const FILETIME &ftNow, const bool v_enableEvent);

	/*!
	 * ĎfBNgċAIɑ܂B
	 * \param ftNow ݓ
	 * \param v_baseDir fBNg
	 * \param v_depth T[݈̌ʒu
	 * \param v_enableEvent m҂tOĂꍇtrue
	 * \param numOfModified ĎXgɕύXi[Q
	 * \return (depth=0)fBNgɐtrueAłȂfalse
	 */
	bool EnumFileRecursive(const FILETIME &ftNow,
						   const tstring &v_baseDir,
						   const int v_depth,
						   const bool v_enableEvent,
						   int &numOfModified);

	/*!
	 * m҂̃Ggm肵`FbNAm肵ꍇAANVs܂B
	 * ̊m蔻ɂ蕡̃Ggm肷ꍇAs̓t@C̍XV̌ÂA
	 * łʂƂȂꍇ͐΃pX̏ōs܂B
	 * \param ftNow ݎ
	 * \param bSkipCommitPending m҂t@CA܂͊mt@CȂꍇtrueɐݒ肳B
	 * \param impersonateUser [ŰUIuWFNg
	 * \return m肵Gg
	 */
	int CheckDoAction(const FILETIME &ftNow, bool &bSkipCommitPending, CImpersonateUser& impersonateUser);

	/*!
	 * ĎԂۑ܂B
	 * \return ۑꂽꍇtrueAۑȂꍇfalse
	 */
	bool Save();

	/*!
	 * ĎԂ𕜌܂B
	 * ɂÅ݂ĎԂ̓Zbg܂B
	 * \return ꂽꍇtrueAȂꍇfalse
	 */
	bool Load();

	/*!
	 * t@C̐΃pXw肵āÃt@C̃t@CTCY擾B
	 * ܂AɁAt@Cǂݍ݃[hŃI[vł邩`FbNAłȂꍇfalseԂ܂B
	 * falseԂꂽꍇ͊i[͕ύX܂B
	 * Win32G[R[h擾ꍇGetLastError()Ăяo܂B
	 * \param v_path t@C̐΃pX
	 * \param pSize t@CTCY̕ۑANULL̏ꍇ͊i[Ȃ
	 * \param pLastModified ŏIXV̕ۑANULL̏ꍇ͊i[Ȃ
	 * \param pAttrs ̕ۑANULL̏ꍇ͊i[Ȃ
	 * \return t@CTCY̎擾Ɏsꍇ
	 */
	static bool getFileInfo(const tstring& v_path, unsigned __int64 *pSize, FILETIME *pLastModified, DWORD *pAttrs) throw();

};
