#pragma once

#include "SettingInfo.hpp"
#include "SettingInfoFactory.hpp"

#include <string>


/*!
 * tH_I_CAO
 */
class CBrowseFolder
{
private:

	/*!
	 * eEBhE
	 */
	HWND hParent_;

	/*!
	 * LvV
	 */
	tstring caption_;

	/*!
	 * fBNgAёIʃfBNg
	 */
	tstring current_;

public:
	CBrowseFolder(HWND hParent, const tstring& caption);

	void SetCurrent(const tstring& current);

	const tstring& GetCurrent() const;

	/*!
	 * tH_I_CAO\AtH_IꂽꍇA
	 * trueԂ܂Bfalsȅꍇ̓LZꂽꍇłB
	 * \param pMalloc tH_pXϊ邽߂ɃVF̃AP[^gp邽ߕKvƂȂ܂B
	 * \return tH_Iꂽꍇtrue
	 */
	bool BrowseFolder(IMalloc* pMalloc);

private:

	/*!
	 * R[obN
	 */
	static int __stdcall CallbackProc(HWND hwnd, UINT uMsg, LPARAM, LPARAM lpData);
};


/*!
 * EBhEpwp
 */
class WindowUtility
{
public:
	virtual ~WindowUtility() {}

	/*!
	 * EBhEnhw肵ăeLXg擾.
	 * \param nh
	 * \return eLXg
	 */
	tstring getWindowText(HWND v_hWnd) const throw();

	/*!
	 * EBhEnhw肵ăeLXgݒ肷.
	 * \param v_hWnd EBhEnh
	 * \param v_text eLXg
	 */
	void setWindowText(HWND v_hWnd, const tstring& v_text) const throw();
};


/*!
 * Ďp[^̐ݒp_CAO
 */
class CSettingDlg : protected CSettingInfoFactory::ErrorInfoListener, protected WindowUtility
{
private:

	/*!
	 * t@Ng̃G[ʒmH
	 * \param G[Ăꍇtrue
	 */
	inline bool isErrorOccured() const
	{
		return errorOccured_;
	}

	/*!
	 * G[NA܂B
	 */
	void clearError()
	{
		errorOccured_ = false;
	}

	/*!
	 * p[^
	 */
	CSettingInfo settingInfo_;

	/*!
	 * t@Ng
	 */
	CSettingInfoFactory factory_;

	/*!
	 * t@NgG[ʒmꂽtO
	 */
	bool errorOccured_;

	/*!
	 * ̃_CAÕEBhEnhB
	 * ̓_CAOvV[WɂďCxg̑Oɐݒ肳܂B
	 */
	HWND hDlg_;

	/* ȉOnInitDialogŐݒ肳qRg[ */

	HWND hDir;
	HWND hName;
	HWND hVerb;
	HWND hApp;
	HWND hParam;
	HWND hShowWindow;
	HWND hWaitWrite;
	HWND hTolerance;
	HWND hDeletePending;
	HWND hLog;
	HWND hMaxProcess;

	HWND hMaxDepth;
	HWND hDirNotificationAPIRetrySpan;
	HWND hDirNotificationAPIExpirySpan;
	HWND hForceInterval;

	HWND hLogLevel;
	HWND hAppCurrentDir;
	HWND hPersist;

	HWND hArchiveOnly;
	HWND hWatchDelay;
	HWND hNotifyOnStart;

	HWND hIgnoreDuplicate;

	HWND hImpersonate;
	HWND hImpersonateUser;
	HWND hImpersonateDomain;
	HWND hImpersonatePassword;

	HWND hWatchDisabled;

private:
	CSettingDlg( const CSettingDlg& ); //<! Ȃ
	CSettingDlg& operator=( const CSettingDlg& ); //<! Ȃ

public:
	/*!
	 * ƂȂ鐳Ďp[^w肵č\z܂B
	 * \param v_settingInfo Ďp[^
	 */
	CSettingDlg( const CSettingInfo& v_settingInfo );

	/*!
	 * fXgN^
	 */
	virtual ~CSettingDlg();

	/*!
	 * _CAO\܂B
	 * \return ͂ꂽꍇtrue
	 */
	bool show(HWND hWnd );

	/*!
	 * p[^\z܂B
	 * ̃\bhshow\bhIĂȂꍇ͌ĂяoĂ͂Ȃ܂B
	 * \param p[^
	 */
	CSettingInfo createSettingInfo() const;

protected:

	/*!
	 * t@Ngp[^̐ݒɉ߂邽тɃG[ʒm܂B
	 * ߂lƂfalsew肷ƃp[^͐ݒ肳܂B
	 * truew肷ƁA񕜂łꍇ͉񕜂ăp[^ݒ肳܂B
	 * Ap[^̉񕜂łȂꍇfalseƓłB
	 * \param v_errorInfo G[
	 * \return 񕜂ꍇtruew肵܂B
	 */
	virtual bool notifyErrorInfo( const tstring& v_errorInfo ) throw();

private:

	/*!
	 * ƂȂp[^_CAÕRg[ɔzu܂B
	 */
	void setInitialParam();

	/*!
	 * _CAOꂽƂɌĂяonhB
	 */
	void OnInitDialog();

	/*!
	 * R}hnh
	 */
	BOOL onCommand( UINT btn );

	/*!
	 * OK{^̃nhB
	 * _CAO͍̓ڂłꍇ̂݃_CAOI܂B
	 */
	void onOK();

	/*!
	 * CANCEL{^̃nhB
	 * _CAO̓͂LZI܂B
	 */
	void onCancel();

	/*!
	 * ĎtH_Inh
	 */
	void onBrowseDir();

	/*!
	 * AvP[VInh
	 */
	void onOpen();

	/*!
	 * Oo͐Inh
	 */
	void onLogSelect();

	/*!
	 * JgfBNgInh
	 */
	void onBrowseCurDir();

	/*!
	 * it@CInh
	 */
	void onSelPersist();

private:

	/*!
	 * _CAOvV[W
	 */
	static LRESULT CALLBACK DlgProc(HWND,UINT,WPARAM,LPARAM);

	/*!
	 * [hbvvV[W
	 */
	static int CALLBACK NoWordwrapProc(LPTSTR lpch, int ichCurrent, int cch, int code);
};
