#pragma once

#include <memory>

/*!
 * K[
 */
class Logger
{
public:
	virtual ~Logger() = 0 {};

	/*!
	 * Oo͂Lł邩?
	 * \return Lłtrue
	 */
	virtual bool IsEnableLogging() const throw() = 0;

	/*!
	 * Ox
	 */
	virtual int GetLogThreshold() const throw() = 0;


	/*!
	 * Ot@CɏށB
	 * OLɂȂĂȂAOt@C̏ꍇ͏o͂ȂB
	 * ܂AȌ݂ɎsĂG[͕ԂȂB
	 * Ot@C̓OނтɒǋL[hŃI[vď݌㑦ɃN[YB
	 * ݂̓Ot@C̊ĎXbhœłꍇz肵ď݂͔rbNB
	 * \param Ox
	 * \param systime ^CX^vAnull̏ꍇ͌ݎgpB
	 * \param errcode Win32̃G[R[hA0ȊȌꍇ̓Oɏo͂B
	 * \param mes bZ[WAnull̏ꍇ͋󕶎
	 */
	virtual void LogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, LPCTSTR mes) = 0;

	/*!
	 * bZ[WIDɂ郍Ot@CɏށB
	 * ȊO͑̃\bhƓlłB
	 * \param Ox
	 * \param systime ^CX^vAnull̏ꍇ͌ݎgpB
	 * \param errcode G[R[h
	 * \param messageID bZ[WID
	 */
	virtual void LogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, DWORD messageID, ...) = 0;

	/*!
	 * ŌɃt@Cɏ񂾎
	 */
	virtual const FILETIME& GetLastWrite() const = 0;

	/*!
	 * IɌĂяoƂŃÕtbV܂̓N[YȂǂ̎ԏ{B
	 * Oޏꍇ͒IɁÃ\bhĂяoKv܂B
	 */
	virtual void Tick(const FILETIME &ftNow) = 0;
};


typedef std::auto_ptr<Logger> LoggerPtr;



/*!
 * K[̎B
 * Ot@C͕KvɂȂƂɊJ܂B
 * sx邩ǂwtOwł܂B
 * ̃tOLłȂΖIClose()ĂяoAfXgN^܂
 * Ot@C͊Jꂽ܂܂ƂȂ܂B
 */
class FileLogger
	: public Logger
{
private:

	HANDLE hLogFile_;

	FILETIME lastWrite_;

	bool enabled_;

	int logThreshold_;

	int lockTryLimit_;

	tstring logPath_;

public:

	FileLogger();

	FileLogger(LPCTSTR logPath);

	virtual ~FileLogger() throw();

	virtual LPCTSTR GetLogPath() const throw();

	virtual void SetLogPath(LPCTSTR logPath) throw();

	virtual void SetEnableLogging(bool enabled) throw();

	virtual bool IsEnableLogging() const throw();

	virtual int GetLogThreshold() const throw();

	virtual void SetLogThreshold(int logLevel);

	virtual void LogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, LPCTSTR mes);

	virtual void LogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, DWORD messageID, ...);

	virtual const FILETIME& GetLastWrite() const;

	/*!
	 * IɌĂяoƂŃÕtbV܂̓N[YȂǂ̎ԏ{B
	 * Oޏꍇ͒IɁÃ\bhĂяoKv܂B
	 */
	virtual void Tick(const FILETIME &ftNow);

	/*!
	 * Ot@CJĂ邩?
	 * \return JĂꍇtrue
	 */
	virtual bool IsOpened() const;

	/*!
	 * Ot@CJĂȂΊJ܂B
	 * Oł邩AOt@C̎w肪Ȃꍇ͊J܂B
	 * ܂t@C̃I[vɎsꍇfalseԂ܂B
	 * t@CJAłɊJĂꍇtrueԂ܂B
	 * \return Ot@CI[vĂꍇtrueAłȂfalse
	 */
	virtual bool Open();

	/*!
	 * Ot@CJĂΕ܂B
	 */
	virtual void Close();

	/*!
	 * O̓tύXĂ΃[e[g܂B
	 * t@CJĂȂΊJ܂B
	 * Iɕ邱Ƃ͂܂B
	 * ݂̃O.bakt@CɃRs[ꂽƁATCY0܂ŏkނ܂B
	 */
	virtual void RotateLog();

protected:

	/*!
	 * p̃Oo̓\bhB
	 * ObZ[W̍\zƃt@Co͂sB
	 * rbNt@C̃I[v͌ĂяoƂŏĂOƂĂB
	 * t@Co͌̃ON[Y̓tbV̏sȂB
	 */
	virtual void InternalLogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, LPCTSTR mes);
};


/*!
 * t@C̔rbNIuWFNg
 */
class FileLockObject
{
private:
	bool locked_;

	HANDLE hFile_;

	OVERLAPPED overlapped_;

public:

	/*!
	 * rbN܂BB
	 * rbNłȂꍇA100mSecƂtryLimit񐔂܂Ŏs܂B
	 * rbNłȂꍇ̓bNȂ̂܂ܐi݂܂B
	 * tryLimit0̏ꍇ͔rbNs܂B
	 * rbNĂ邩IsLockedŔ肵܂B
	 * \param tryLimit rbNső񐔁A0̏ꍇ͔rbNȂB
	 */
	FileLockObject(HANDLE hFile, int tryLimit);

	~FileLockObject();

	inline bool IsLocked() const
	{
		return locked_;
	}

	void Release();
};
