# board_filter.py
#
# Copyright (C) 2006 by Aiwota Programmer <aiwotaprog@tetteke.tk>
# Distributed under the terms of the GNU General Public License v2
#
# This module is a plugin for Fukui no Namari 2ch Browser.
# Append some filtering menus to the board window.

import pygtk
pygtk.require("2.0")
import gtk
import time

from FukuiNoNamari.board_plugin_base import BoardPluginBase

# version must be two int tuple.
version = (0, 2)


# class name must be BoardPlugin
class BoardPlugin(BoardPluginBase):

    def initialize(self):
        self.get_widgets()

        # append separator to menuitem.
        self.append_separator()

        # append new res filter menu to menuitem.
        # extract the threads which have new res.
        self.append_menu("_New Res Filter", self.is_new_res)

        # append start within hour menu to menuitem.
        # extract the threads which have started within one hour.
        self.append_menu("_Start within Hour Filter",self.is_start_within_hour)

        # append clear filter menu to menuitem.
        # clear extraction.
        self.append_menu("_Clear Filter", None)

    def get_widgets(self):
        self.treeview = self.widget_tree.get_widget("treeview")
        self.menuitem = self.widget_tree.get_widget("menu_edit").get_submenu()

    def append_separator(self):
        separator = gtk.SeparatorMenuItem()
        separator.show()
        self.menuitem.append(separator)

    def append_menu(self, label, pred):
        new_filter_menu_item = gtk.MenuItem(label)
        new_filter_menu_item.show()
        new_filter_menu_item.connect("activate", self.on_menu_activate, pred)
        self.menuitem.append(new_filter_menu_item)

    def on_menu_activate(self, widget, predicate):
        model = self.treeview.get_model()
        if model:
            model.refilter(predicate)

    def is_new_res(self, model, item):
        # model is FukuiNoNamari.threadlistmodel.ThreadListModel.
        # item is dictionary which keys are
        # id, num, title, res, lineCount, lastModified, average, oldRes
        # and types are
        # str, int, str, int, int, int, float, int.

        res = item["res"]
        lineCount = item["lineCount"]
        return res and lineCount and res > lineCount

    def is_start_within_hour(self, model, item):
        thread_id = item["id"]
        try:
            thread_id = int(thread_id)
        except ValueError:
            return False
        else:
            # I want to use LastModified of subject.txt, but...
            now = time.time()
            dur = now - thread_id
            return 0 <= dur < 3600
