# board_column_begin.py
#
# Copyright (C) 2006 by Aiwota Programmer <aiwotaprog@tetteke.tk>
# Distributed under the terms of the GNU General Public License v2
#
# Add a column for showing the increase of the number of res.

import pygtk
pygtk.require("2.0")
import gtk

from FukuiNoNamari.board_plugin_base import BoardPluginBase
from FukuiNoNamari.board_column import BaseTreeViewColumn

version = (0, 2)


# class name must be BoardPlugin
class BoardPlugin(BoardPluginBase):

    def initialize(self):
        treeview = self.widget_tree.get_widget("treeview")
        cell = gtk.CellRendererText()
        TreeViewColumn_IncreaseRes(cell, treeview)


# Column for showing the increase of the number of res.
class TreeViewColumn_IncreaseRes(BaseTreeViewColumn):
    id = "increase"     # id for this column
    label = "Increase"  # for column header text
    def_width = 50      # default width of this column

    def setup(self):
        BaseTreeViewColumn.setup(self)
        self.treeview.get_model().set_compare_func(
            self.id, self.compare, self.key_for_compare)

    def compare(self, v1, v2, reverse):
        if not reverse:
            if v1 == -1 and v2 == -1:
                return 0
            elif v1 == -1:
                return 1
            elif v2 == -1:
                return -1
            elif v1 == 0 and v2 == 0:
                return 0
            elif v1 == 0:
                return 1
            elif v2 == 0:
                return -1
        if v1 > v2:
            return 1
        elif v1 < v2:
            return -1
        else:
            return 0

    def key_for_compare(self, item_dict):
        if item_dict["num"] == 0:
            return -1

        old = item_dict["oldRes"]

        if old == 0:
            return 0

        res = item_dict["res"]

        if res == 0:
            return 0
        return res - old

    def on_cell_data(self, column, cell, model, iter):
        self.updated_thread_highlight(column, cell, model, iter)

        dic = model.get_dict(iter)

        old = dic["oldRes"]
        res = dic["res"]

        if old == 0 or res == 0:
            cell.set_property("text", "")
        else:
            inc = res - old
            if inc == 0:
                cell.set_property("text", "")
            else:
                cell.set_property("text", inc)
