# board_column_begin.py
#
# Copyright (C) 2006 by Aiwota Programmer <aiwotaprog@tetteke.tk>
# Distributed under the terms of the GNU General Public License v2
#
# Add a column for showing the beginning time of threads.

import pygtk
pygtk.require("2.0")
import gtk
import time

from FukuiNoNamari.board_plugin_base import BoardPluginBase
from FukuiNoNamari.board_column import BaseTreeViewColumn

version = (0, 2)


# class name must be BoardPlugin
class BoardPlugin(BoardPluginBase):

    def initialize(self):
        treeview = self.widget_tree.get_widget("treeview")
        cell = gtk.CellRendererText()
        TreeViewColumn_BeginningTime(cell, treeview)


# Column for showing the beginning time of threads.
class TreeViewColumn_BeginningTime(BaseTreeViewColumn):
    id = "begin"     # identifier for this column
    label = "Begin"  # for column header text
    def_width = 150  # default width of this column

    def setup(self):
        BaseTreeViewColumn.setup(self)
        self.treeview.get_model().set_compare_func(
            self.id, None, self.key_for_compare)

    def key_for_compare(self, item_dict):
        try:
            return int(item_dict["id"])
        except ValueError:
            return 0

    def on_cell_data(self, column, cell, model, iter):
        self.updated_thread_highlight(column, cell, model, iter)

        thread_id_str = model.get_dict(iter)["id"]
        try:
            thread_id = int(thread_id_str)
            if thread_id == 0:
                format = ""
            else:
                t = time.localtime(thread_id)
                format = time.strftime("%Y/%m/%d(%a) %H:%M:%S", t)
        except:
            format = thread_id_str

        cell.set_property("text", format)
