/**
 * Chart series.
 *
 * @copyright  2016 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @module     core/chart_series
 */
define("core/chart_series",[],(function(){function Series(label,values){if("string"!=typeof label)throw new Error("Invalid label for series.");if("object"!=typeof values)throw new Error("Values for a series must be an array.");if(values.length<1)throw new Error("Invalid values received for series.");this._colors=[],this._label=label,this._values=values}return Series.prototype.TYPE_DEFAULT=null,Series.prototype.TYPE_LINE="line",Series.prototype._colors=null,Series.prototype._fill=!1,Series.prototype._label=null,Series.prototype._labels=null,Series.prototype._smooth=!1,Series.prototype._type=Series.prototype.TYPE_DEFAULT,Series.prototype._values=null,Series.prototype._xaxis=null,Series.prototype._yaxis=null,Series.prototype.create=function(obj){var s=new Series(obj.label,obj.values);return s.setType(obj.type),s.setXAxis(obj.axes.x),s.setYAxis(obj.axes.y),s.setLabels(obj.labels),obj.colors&&obj.colors.length>1?s.setColors(obj.colors):s.setColor(obj.colors[0]),s.setFill(obj.fill),s.setSmooth(obj.smooth),s},Series.prototype.getColor=function(){return this._colors[0]||null},Series.prototype.getColors=function(){return this._colors},Series.prototype.getCount=function(){return this._values.length},Series.prototype.getFill=function(){return this._fill},Series.prototype.getLabel=function(){return this._label},Series.prototype.getLabels=function(){return this._labels},Series.prototype.getSmooth=function(){return this._smooth},Series.prototype.getType=function(){return this._type},Series.prototype.getValues=function(){return this._values},Series.prototype.getXAxis=function(){return this._xaxis},Series.prototype.getYAxis=function(){return this._yaxis},Series.prototype.hasColoredValues=function(){return this._colors.length==this.getCount()},Series.prototype.setColor=function(color){this._colors=[color]},Series.prototype.setColors=function(colors){if(colors&&colors.length!=this.getCount())throw new Error("When setting multiple colors there must be one per value.");this._colors=colors||[]},Series.prototype.setFill=function(fill){this._fill=void 0===fill?null:fill},Series.prototype.setLabels=function(labels){this._validateLabels(labels),labels=void 0===labels?null:labels,this._labels=labels},Series.prototype.setSmooth=function(smooth){smooth=void 0===smooth?null:smooth,this._smooth=smooth},Series.prototype.setType=function(type){if(type!=this.TYPE_DEFAULT&&type!=this.TYPE_LINE)throw new Error("Invalid serie type.");this._type=type||null},Series.prototype.setXAxis=function(index){this._xaxis=index||null},Series.prototype.setYAxis=function(index){this._yaxis=index||null},Series.prototype._validateLabels=function(labels){if(labels&&labels.length>0&&labels.length!=this.getCount())throw new Error("Series labels must match series values.")},Series}));

//# sourceMappingURL=chart_series.min.js.map