/**
 * Controls the preference for an individual notification type on the
 * message preference page.
 *
 * @module     core_message/notification_preference
 * @class      notification_preference
 * @package    message
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/notification_preference",["jquery","core/ajax","core/notification","core_message/notification_processor"],(function($,Ajax,Notification,NotificationProcessor){var SELECTORS_PROCESSOR="[data-processor-name]",SELECTORS_STATE_INPUTS="[data-state] input",NotificationPreference=function(element,userId){this.root=$(element),this.userId=userId};return NotificationPreference.prototype.getPreferenceKey=function(){return this.root.attr("data-preference-key")},NotificationPreference.prototype.getLoggedInPreferenceKey=function(){return this.getPreferenceKey()+"_loggedin"},NotificationPreference.prototype.getLoggedOffPreferenceKey=function(){return this.getPreferenceKey()+"_loggedoff"},NotificationPreference.prototype.getProcessors=function(){return this.root.find(SELECTORS_PROCESSOR).map((function(index,element){return new NotificationProcessor($(element))}))},NotificationPreference.prototype.startLoading=function(){this.root.addClass("loading"),this.root.find(SELECTORS_STATE_INPUTS).prop("disabled",!0)},NotificationPreference.prototype.stopLoading=function(){this.root.removeClass("loading"),this.root.find(SELECTORS_STATE_INPUTS).prop("disabled",!1)},NotificationPreference.prototype.isLoading=function(){return this.root.hasClass("loading")},NotificationPreference.prototype.save=function(){if(this.isLoading())return $.Deferred().resolve();this.startLoading();var loggedInValue="",loggedOffValue="";this.getProcessors().each((function(index,processor){processor.isLoggedInEnabled()&&(""===loggedInValue?loggedInValue=processor.getName():loggedInValue+=","+processor.getName()),processor.isLoggedOffEnabled()&&(""===loggedOffValue?loggedOffValue=processor.getName():loggedOffValue+=","+processor.getName())})),""===loggedInValue&&(loggedInValue="none"),""===loggedOffValue&&(loggedOffValue="none");var request={methodname:"core_user_update_user_preferences",args:{userid:this.userId,preferences:[{type:this.getLoggedInPreferenceKey(),value:loggedInValue},{type:this.getLoggedOffPreferenceKey(),value:loggedOffValue}]}};return Ajax.call([request])[0].fail(Notification.exception).always(function(){this.stopLoading()}.bind(this))},NotificationPreference}));

//# sourceMappingURL=notification_preference.min.js.map