/**
 * Action selector.
 *
 * To handle 'save' events use: actionselector.on('save')
 * This will receive the information to display in popup.
 * The actions have the format [{'text': sometext, 'value' : somevalue}].
 *
 * @package    tool_lp
 * @copyright  2016 Serge Gauthier - <serge.gauthier.2@umontreal.ca>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/actionselector",["jquery","core/notification","core/ajax","core/templates","tool_lp/dialogue","tool_lp/event_base"],(function($,Notification,Ajax,Templates,Dialogue,EventBase){var ActionSelector=function(title,message,actions,confirm,cancel){EventBase.prototype.constructor.apply(this,[]),this._title=title,this._message=message,this._actions=actions,this._confirm=confirm,this._cancel=cancel,this._selectedValue=null,this._reset()};return(ActionSelector.prototype=Object.create(EventBase.prototype))._selectedValue=null,ActionSelector.prototype._popup=null,ActionSelector.prototype._title=null,ActionSelector.prototype._message=null,ActionSelector.prototype._actions=null,ActionSelector.prototype._confirm=null,ActionSelector.prototype._cancel=null,ActionSelector.prototype._afterRender=function(){var self=this;self._find('[data-action="action-selector-confirm"]').attr("disabled","disabled"),self._find('[data-region="action-selector-radio-buttons"]').change((function(){self._selectedValue=$("input[type='radio']:checked").val(),self._find('[data-action="action-selector-confirm"]').removeAttr("disabled"),self._refresh.bind(self)})),self._find('[data-action="action-selector-cancel"]').click((function(e){e.preventDefault(),self.close()})),self._find('[data-action="action-selector-confirm"]').click((function(e){e.preventDefault(),self._selectedValue.length&&(self._trigger("save",{action:self._selectedValue}),self.close())}))},ActionSelector.prototype.close=function(){this._popup.close(),this._reset()},ActionSelector.prototype.display=function(){var self=this;return self._render().then((function(html){self._popup=new Dialogue(self._title,html,self._afterRender.bind(self))})).fail(Notification.exception)},ActionSelector.prototype._find=function(selector){return $(this._popup.getContent()).find(selector)},ActionSelector.prototype._refresh=function(){var self=this;return self._render().then((function(html){self._find('[data-region="action-selector"]').replaceWith(html),self._afterRender()}))},ActionSelector.prototype._render=function(){var choices=[];for(var i in this._actions)choices.push(this._actions[i]);var content={message:this._message,choices:choices,confirm:this._confirm,cancel:this._cancel};return Templates.render("tool_lp/action_selector",content)},ActionSelector.prototype._reset=function(){this._popup=null,this._selectedValue=""},ActionSelector}));

//# sourceMappingURL=actionselector.min.js.map