<?php

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_editorSettings()
{
    global $CFG;

    print_section_header('HTMLエディタに関する設定');

    print_subsection_header_fs_switch('FS_ENABLE_DRAGMATHEQUATIONEDITOR');
    print_notice_message('注意', 'この設定はMoodle1.9以降においてのみ意味を持ちます．');
    echo '　Moodleには数式を表現する手段としてTeXフィルタ(mimeTeX)があります．';
    echo 'DragMath Equation Editorは数式エディタのようなインタフェースを用いることで';
    echo '容易にmimeTeX形式の数式を作成することができるツールです．';
    echo '当然ですが，'.color_red('サイトのTeXフィルタを有効に設定しないと意味がありません．');
    newline();
    if (!empty($CFG->textfilters)) {
        $filters = explode(',', $CFG->textfilters);
        if (array_search('filter/tex', $filters) === FALSE) {
            echo '　現在，'.color_red('TeXフィルタは無効').'です．';
        } else {
            echo '　現在，'.color_blue('TeXフィルタは有効').'です．';
        }
    } else {
        echo '　現在，'.color_red('TeXフィルタは無効').'です．';
    }
    newline();
    newline();
    echo '　DragMath Equation Editorを有効にすると，HTMLエディタ（HTMLarea）のツールバーに';
    echo '[π]のようなボタンが追加されます．なお，DragMath Equation Editorは';
    echo 'moodle.orgのdownload, <a href="http://moodle.org/mod/data/view.php?d=13&amp;rid=1454&amp;filter=1" target="_blank">';
    echo 'modules and plugins</a>で入手可能ですが，単にパッケージを展開するだけではなく，';
    echo 'Moodleのソースも変更する必要があったためfs_moodleに組み込んだ状態での配布を行います．';
    echo 'DragMath Equation Editorについての正確な紹介を以下に表示します．';
    newline();
    newline();
    echo color_blue('The DragMath editor was created by Christopher Sangwin and Alexander Billingsley at the University of Birmingham as part of the STACK project.Special thanks to John Isner for working on integrating DragMath with the HTML-Editor in Moodle. ');
    print_fs_switch_condition('FS_ENABLE_DRAGMATHEQUATIONEDITOR');
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_ENABLE_MODIFYHTMLAREATOOLBUTTONDISPLAY');
    print_notice_message('注意', 'この設定はHTMLエディタとしてHTMLareaを使用している場合，つまりMoodle1.8/Moodle1.9においてのみ意味を持ちます．Moodle2.0以降は無意味です');
    echo '　HTMLエディタにスペルチェッカーやDragMathEditorを追加するとアイコンが増えます．';
    echo 'HTMLエディタの使用箇所によってはボタンが右端にハミ出す場合があります．';
    echo '特にこの現象はフォーラム投稿の書き込みで顕著です．ところがWikiでは問題ありません．';
    echo '時と場合によって正しく表示できたりできなかったりするため，完璧な対策は行えませんでした．';
    newline();
    echo '　もし気になるならばこの設定を有効にして下さい．';
    print_fs_switch_condition('FS_ENABLE_MODIFYHTMLAREATOOLBUTTONDISPLAY');
    print_subsubsection_footer();

    print_subsection_header('IE/Firefox以外でもHTMLエディタを利用可能とする設定');
    echo '　あなたが現在使用しているWebブラウザの種類('.color_blue('$_SERVER['."'HTTP_USER_AGENT'".']').')は，';
    newline();
    echo '　　'.color_blue($_SERVER['HTTP_USER_AGENT']);
    newline();
    echo 'です．';
    echo '現在の設定でHTMLエディタは'.(can_use_html_editor() ? color_blue('利用できます') : color_red('使用できません')).'．';
    newline();
    echo '　現時点でIE/Firefox以外にHTMLエディタを（非公式ですが）利用可能なのは'.color_blue('Safari').'と'.color_blue('Chrome').'のみです．';
    print_notice_message('お願い', '現在，Safari, Chromeの全てのバージョンでの動作を確認した訳ではありません．古いバージョンで動作しないことを確認した場合はご連絡下さい．');
    newline();
    print_subsubsection_header_fs_switch('FS_DISABLE_USEHTMLEDITOR_SAFARI');
    echo '　アップル社製WebブラウザSafari（Mac, Windows）でもIE/Firefox同様にHTMLエディタを利用可能とする設定です．';
    print_fs_switch_condition('FS_DISABLE_USEHTMLEDITOR_SAFARI');
    print_notice_message('注意', 'iPhone等に搭載されているモバイルSafariではHTMLエディタは利用できません．この設定を有効にしてもiPhone系は自動識別されて無視されるのでご安心下さい．');
    print_subsubsection_footer();
    print_subsubsection_header_fs_switch('FS_DISABLE_USEHTMLEDITOR_CHROME');
    echo '　グーグル社製WebブラウザChromeでもIE/Firefox同様にHTMLエディタを利用可能とする設定です．';
    print_fs_switch_condition('FS_DISABLE_USEHTMLEDITOR_CHROME');
    print_subsubsection_footer();
    print_subsection_footer();

    print_section_footer();
}

fsconfig_check_editorSettings();

?>