<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_nanogongSettings()
{
    global $fsCFG;

    print_section_header('NanoGongに関する設定');

    print_subsection_header_fs_switch('FS_ENABLE_NANOGONG');
    echo '　NanoGongのインストールが終わったら，機能を有効にするためにこのスイッチを有効にして下さい．';
    print_fs_switch_condition('FS_ENABLE_NANOGONG');
    print_subsection_footer();

    print_section_footer();

//-----------------

    print_section_header('NanoGongに関する情報');
    print_subsection_header('NanoGongとは？');
    echo '　'.fs_linktext('http://gong.ust.hk/', true, 'NanoGong').'はWebブラウザを介して音声ファイルの録音と再生を手軽に行うことができるJavaアプレットです．';
    echo 'Moodleとの親和性が高く，Moodle用のブロックなどをNanoGong本家で公開しています．';
    print_notice_message('補注', '2011/5/21現在，NanoGong4.2では，Moodle1.9.11+まで対応しています．現段階ではMoodle2には非対応です．');
    echo '　さて，NanoGongをMoodleにインストールすると，Activity（活動モジュール）とフィルター，HTMLエディタ（HTMLArea）へのボタンの追加と言語パッケージ，それと開発途中のようですがassignment（課題）においてNanoGongが利用可能になります．';
    echo 'Activityはコンテンツとして中央のコラムに追加可能で，教師が全学生に向けて提示するメッセージ（テキスト＋音声）に対して学生が一人一人，メッセージ（テキスト＋音声）を送信できます．';
    echo '教師はそれぞれのメッセージに対して返信と採点が可能です．';
    echo 'この活動モジュールだけで十分にAssignmentの代用ができそうです．';
    echo 'ただ，評定には採点が反映されないため，Assignmentモジュールも開発中なのでしょう．';
    print_notice_message('注意', '　とりあえず，2011/05/21の段階ではAssignmentについては全く考慮しません．');
    print_subsection_footer();

    print_subsection_header('NanoGongのインストール');
    echo '　NanoGongのMoodleへのインストール方法は'.fs_linktext('http://www.urano-ken.com/blog/2011/03/10/1891/', true, '浦野氏のWebページ').'がとても分かり易くて参考になります．';
    newline();
    echo '　NanoGongは本家ページからダウンロードする際にユーザ登録（無料）が必要ですので，fs_moodleパッケージに同梱していません．';
    echo '必ず御自身で本家サイトよりダウンロードして下さい．';
    newline();
    newline();

    echo '　Activity（nanogong-module-4.2.zip）は単独でインストールできます（その代わりHTMLエディタで音声録音はできません）．';
    echo 'フィルター（nanogong-filter-4.2.zip）も特に問題なくインストールできるでしょう．';
    echo 'ただ，HTMLエディタへのボタンの追加等のためのインストール（nanogong-htmlarea-4.2-moodle-1.9.11plus.zip）はMoodleのソースファイルのいくつかを上書きしなくてはいけません．';
    echo 'fs_moodleではそれらのファイルにいくつかの修正を加えていますし，特にweblib.phpは少なくないサイトで何らかの修正を加えているでしょう．';
    echo 'また，言語パック（en_utf8）を更新すると，NanoGongのための追加語句も消えてしまいます．';
    newline();
    newline();
    echo '　そこで，fs_moodleでは通常のNanoGongのインストールとは異なる方法を取っています．';
    echo '簡単に言いますと，単にzipファイルを展開して追加するだけのファイルは管理者の皆様に手作業で追加して貰います．';
    echo 'それに対してMoodleオリジナルのファイルを改変する（：上書き）箇所は，先に私がコードに追加しましたので，コピーする必要はありません．';
    echo '詳しくは以下の文章をお読み下さい．';
    print_subsection_footer();

    print_subsection_header('fs_moodleへのNanoGongのインストール手順');
    echo '　NanoGong本家のページから以下の３つのzipファイルをダウンロードして下さい．';
    newline();
    echo '<ul>';
    echo '<li>nanogong-module-4.2.zip： Activity（活動）はそのままnanogongフォルダをmoodle/modにコピーして下さい． </li>';
    echo '<li>nanogong-filter-4.2.zip: フィルターもそのままnanogongフォルダをmoodle/filtersにコピーして下さい． </li>';
    echo '<li>nanogong-htmlarea-4.2-moodle-1.9.11plus.zip：HTMLエディタの改造，は以下の通りに一部のファイルはコピーしないで下さい．</li>';
    echo '</ul>';
    newline();
    echo color_blue('nanogong-htmlarea-4.2-moodle-1.9.11plus.zip').'の展開とコピー';
    newline();
    echo '　zipファイル中のlang/en_utf8/editor.phpはコピーしなくて結構です．';
    echo 'この言語パック内に追加されたNanoGong用の語句はmoodle/lib/fs_moodle/lang/en_utf8, ja_utf8/editor.phpに抜き出してあります（ja_utf8は私が和訳しました）．';
    newline();
    echo '　zipファイル中のlib/weblib.phpはコピーしないで下さい．';
    newline();
    echo '　zipファイル中のlib/editor/htmlareaのhtmlarea.php, dialog.jsはコピーしないで下さい．';
    newline();
    echo '　images, popupsフォルダ含め，その他のファイルはコピーして下さい．';
    echo '追加は構わないのですが， オリジナルのファイルの上書きは一切行わないで下さい．';
    print_subsection_footer();

    print_subsection_header('NanoGongの有効化');
    echo '　上記手順のように必要なファイルのみをmoodleフォルダにコピーし終えたら，NanoGongを有効にします．';
    echo 'まず，このページ上部にあります'.color_blue('FS_ENABLE_NANOGONG').'を有効にして下さい．';
    echo 'NanoGong用にMoodleオリジナルソースに追加したコードが有効になります．';
    newline();
    echo '　次いで，'.color_blue('活動モジュールの有効化').'と'.color_blue('フィルタの有効化').'を行って下さい．';
    echo 'この手順は上記浦野氏のWebページを参考にして下さい．';
    print_notice_message('情報', 'fs_moodleにおけるNanoGong関係の修正個所はNanoGongに関係する修正個所をご覧下さい．');
    print_subsection_footer();

    print_subsection_header('注意とお願い');
    echo '　fs_moodleのNanoGongへの対応はNanoGongの特定のバージョン（NanoGong4.2: 2011/05/21現在）に対してのみ行われています．';
    echo '新しいバージョンのNanoGongが出た際には白井達也（shirai@mech.suzuka-ct.ac.jp）へご連絡下さい．不具合がある場合は対処します．';
    newline();
    echo '　fs_moodleのNanoGongへの対応についての最新の情報は，カッコ内のWikiページ（'.fs_linktext('http://www.suzuka-ct.ac.jp/mech/moodle/mod/wiki/view.php?id=320&page=NanoGong%E3%81%B8%E3%81%AE%E5%AF%BE%E5%BF%9C', true, 'NanoGongへの対応').'）をチェックして下さい．';
    print_subsection_footer();

    print_section_footer();
}

fsconfig_check_nanogongSettings();

?>