<?php

// moodleフォルダの全ファイルを対象にBOMの有無を調べる

    require_once('../../../config.php');
    require_once($CFG->libdir.'/fs_moodle/fs_status/lib.php');

    $displaydetail = optional_param('detail', false, PARAM_BOOL);
    if ($displaydetail) define('BOM_DISPLAYDETAIL', true);
        else            define('BOM_DISPLAYDETAIL', false);

    function check_bom($fullpath)
    {
        if (is_file($fullpath)) {
            if (!file_exists($fullpath)) {
                echo "警告：ファイルが存在しません（$fullpath）．<br />\n";
                return false;
            }
            $path_info = fs_pathinfo($fullpath);
            if (empty($path_info['extension'])) $path_info['extension'] = '';
            switch (strtolower($path_info['extension'])) {
                case 'php':
                case 'html':
                    if (check_config_head_and_tail($fullpath) == -2) {
                            echo "チェック：{$fullpath}　→　<b>異常（BOMあり）</b><br />\n";
                    } else {
                        if (BOM_DISPLAYDETAIL) {
                            echo "チェック：{$fullpath}　→　正常<br />\n";
                        }
                    }
                    return true;
                default :
                    break;
            }
            return false;
        } else if (is_dir($fullpath)) {
            $dir = opendir($fullpath);
            while (($ent = readdir($dir)) !== FALSE) {
                if (($ent == '.') or ($ent == '..')) continue;
                check_bom($fullpath.'/'.$ent);
            }
            closedir($dir);
            return true;
        }
        echo "警告：このパス（$fullpath）はファイルでもフォルダでもありません．<br />\n";
        return false;
    }

    page_header();

    // チェック($CFG->dirroot)
    if (empty($CFG->dirroot)) {
        echo '$CFG->dirrootが宣言されていません（config.phpを正しく読み込めませんでした）．<br />'."\n";
        die;
    }
    if (!is_dir($CFG->dirroot)) {
        echo '$CFG->dirroot('.$CFG->dirroot.")はフォルダではありません．<br />\n";
        die;
    }

    echo "<b>【BOMチェック開始】</b><br />\n";
    $dir = opendir($CFG->dirroot);
    while (($ent = readdir($dir)) !== FALSE) {
        if (($ent == '.') or ($ent == '..')) continue;
        $fullpath = $CFG->dirroot.'/'.$ent;
        check_bom($fullpath);
    }
    closedir($dir);
    echo "<b>【BOMチェック終了】</b><br />\n";
//  newline();
//  print_linkto_mainmenu();
    output_CloseWindowButton(true);

    page_footer();

?>