<?php  // $Id: edit_form.php,v 1.2.2.7 2009/09/26 16:27:49 skodak Exp $

require_once($CFG->dirroot.'/lib/formslib.php');

class tag_edit_form extends moodleform {

    function definition () {

        $mform =& $this->_form;

        $mform->addElement('header', 'tag', get_string('description','tag'));

        $mform->addElement('hidden', 'id');
        $mform->setType('id', PARAM_INT);

        $systemcontext   = get_context_instance(CONTEXT_SYSTEM);

        if (has_capability('moodle/tag:manage', $systemcontext)) {
            $mform->addElement('text', 'rawname', get_string('name', 'tag'), 
                    'maxlength="'.TAG_MAX_LENGTH.'" size="'.TAG_MAX_LENGTH.'"');
        }

        $mform->addElement('htmleditor', 'description', get_string('description', 'tag'), array('rows'=>20));

        $mform->addElement('format', 'descriptionformat', get_string('format'));

        if (has_capability('moodle/tag:manage', $systemcontext)) {
           $mform->addElement('checkbox', 'tagtype', get_string('officialtag', 'tag')); 
        }

        $mform->addElement('html', '<br/><div id="relatedtags-autocomplete-container">');
        $mform->addElement('textarea', 'relatedtags', get_string('relatedtags','tag'), 'cols="50" rows="3"');
        $mform->setType('relatedtags', PARAM_TAGLIST);
        $mform->addElement('html', '</div>');
        $mform->addElement('html', '<div id="relatedtags-autocomplete"></div>');
// (Debug024): blogの編集時にコースIDを渡していない箇所の修正 (2009/07/21)
// (Debug024): ここから追加
        global $COURSE;
        $mform->addElement('hidden', 'courseid');
        $mform->setType('courseid', PARAM_INT);
        $mform->setDefault('courseid', $COURSE->id);
// (Debug024): ここまで追加

        $this->add_action_buttons(false, get_string('updatetag', 'tag'));

    }

}

?>
