<?php //$Id: forgot_password_form.php,v 1.7.2.1 2007/11/23 22:12:35 skodak Exp $

require_once $CFG->libdir.'/formslib.php';

class login_forgot_password_form extends moodleform {

    function definition() {
        $mform    =& $this->_form;
        $renderer =& $mform->defaultRenderer();

        $mform->addElement('header', '', get_string('passwordforgotten'), '');

        $mform->addElement('text', 'username', get_string('username'));
        $mform->setType('username', PARAM_RAW);

        $mform->addElement('text', 'email', get_string('email'));
        $mform->setType('email', PARAM_RAW);

        $this->add_action_buttons(true, get_string('ok'));
    }

    function validation($data, $files) {
        global $CFG;

        $errors = parent::validation($data, $files);

// (Shirai166): パスワード忘失時の再発行要求時にアカウント名とメールアドレスの両方を入力しないと受け付けない制限の追加 (2009/09/11)
// (Shirai166): ここから追加
            $emailonly = $usernameonly = $emailandusername = $noemailandusername = false;
            if (!empty($data['username'])) $usernameonly = true;
            if (!empty($data['email']))    $emailonly    = true;
            if ($usernameonly and $emailonly) {
                $emailonly = $usernameonly = false;
                $emailandusername          = true;
            } else if (!$usernameonly and !$emailonly) $noemailandusername = true;
            if (fs_function_enable('FS_ENABLE_NEEDBOTHINFO2REQUESTPASSWORD')) $needboth = true; else $needboth = false;
// (Shirai166): ここまで追加
// (Shirai166): ここから修正
//      if ((!empty($data['username']) and !empty($data['email'])) or (empty($data['username']) and empty($data['email']))) {
        if (!$needboth and ($emailandusername or $noemailandusername)) {
// (Shirai166): ここまで修正
            $errors['username'] = get_string('usernameoremail');
            $errors['email']    = get_string('usernameoremail');
// (Shirai166): ここから追加
        } else if ($needboth and !$emailandusername) {
            $errors['username'] = get_string('usernameandemail', 'fs_moodle');
            $errors['email']    = get_string('usernameandemail', 'fs_moodle');
// (Shirai166): ここまで追加
// (Shirai166): ここからコメントアウト
//      } else if (!empty($data['email'])) {
// (Shirai166): ここから追加
        } else {
        if ($needboth or (!$needboth and $emailonly)) {
// (Shirai166): ここまで追加
            if (!validate_email($data['email'])) {
                $errors['email'] = get_string('invalidemail');

            } else if (count_records('user', 'email', $data['email']) > 1) {
                $errors['email'] = get_string('forgottenduplicate');

            } else {
                if ($user = get_complete_user_data('email', $data['email'])) {
                    if (empty($user->confirmed)) {
                        $errors['email'] = get_string('confirmednot');
                    }
                }
                if (!$user and empty($CFG->protectusernames)) {
                    $errors['email'] = get_string('emailnotfound');
                }
            }

// (Shirai166): ここからコメントアウト
//      } else {
// (Shirai166): ここから追加
        }
        if ($needboth or (!$needboth and $usernameonly)) {
// (Shirai166): ここまで追加
            if ($user = get_complete_user_data('username', $data['username'])) {
                if (empty($user->confirmed)) {
                    $errors['email'] = get_string('confirmednot');
                }
            }
            if (!$user and empty($CFG->protectusernames)) {
                $errors['username'] = get_string('usernamenotfound');
            }
        }
// (Shirai166): ここから追加
        }
// (Shirai166): ここまで追加

        return $errors;
    }

}

?>