/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jdesktop.layout.LayoutStyle;

class MetalLayoutStyle
extends LayoutStyle {
    private boolean isOcean = false;

    public MetalLayoutStyle() {
        try {
            Method method = MetalLookAndFeel.class.getMethod("getCurrentTheme", null);
            this.isOcean = ((MetalTheme)method.invoke(null, (Object[])null)).getName() == "Ocean";
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (IllegalArgumentException iae2) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public int getPreferredGap(JComponent source, JComponent target, int type, int position, Container parent) {
        int offset;
        super.getPreferredGap(source, target, type, position, parent);
        if (type == 3) {
            if (position == 3 || position == 7) {
                int gap = this.getButtonChildIndent(source, position);
                if (gap != 0) {
                    return gap;
                }
                return 12;
            }
            type = 0;
        }
        String sourceCID = source.getUIClassID();
        String targetCID = target.getUIClassID();
        if (type == 0) {
            if (sourceCID == "ToggleButtonUI" && targetCID == "ToggleButtonUI") {
                ButtonModel sourceModel = ((JToggleButton)source).getModel();
                ButtonModel targetModel = ((JToggleButton)target).getModel();
                if (sourceModel instanceof DefaultButtonModel && targetModel instanceof DefaultButtonModel && ((DefaultButtonModel)sourceModel).getGroup() == ((DefaultButtonModel)targetModel).getGroup() && ((DefaultButtonModel)sourceModel).getGroup() != null) {
                    return 2;
                }
                if (this.isOcean) {
                    return 6;
                }
                return 5;
            }
            offset = 6;
        } else {
            offset = 12;
        }
        if ((position == 3 || position == 7) && (sourceCID == "LabelUI" && targetCID != "LabelUI" || sourceCID != "LabelUI" && targetCID == "LabelUI")) {
            return this.getCBRBPadding(source, target, position, offset + 6);
        }
        return this.getCBRBPadding(source, target, position, offset);
    }

    int getCBRBPadding(JComponent source, JComponent target, int position, int offset) {
        if ((offset = super.getCBRBPadding(source, target, position, offset)) > 0) {
            int buttonAdjustment = this.getButtonAdjustment(source, position);
            if (buttonAdjustment == 0) {
                buttonAdjustment = this.getButtonAdjustment(target, this.flipDirection(position));
            }
            offset -= buttonAdjustment;
        }
        if (offset < 0) {
            return 0;
        }
        return offset;
    }

    private int getButtonAdjustment(JComponent source, int edge) {
        String uid = source.getUIClassID();
        if (uid == "ButtonUI" || uid == "ToggleButtonUI" ? !this.isOcean && (edge == 3 || edge == 5) : edge == 5 && (uid == "RadioButtonUI" || !this.isOcean && uid == "CheckBoxUI")) {
            return 1;
        }
        return 0;
    }

    public int getContainerGap(JComponent component, int position, Container parent) {
        super.getContainerGap(component, position, parent);
        return this.getCBRBPadding(component, position, 12 - this.getButtonAdjustment(component, position));
    }
}

