require 'fileutils'
require 'jcode'
$KCODE = 's'

$runtime = [
'MD',
'ML',
'MT',
'MDd',
'MLd',
'MTd',
]

def makeline(a)
  s = ''
  a.each { |v|
    s = s + ' ' if s.size > 0
    s = s + v.gsub(/\//, '\\')
  }
  return s
end

$defs = '-DHAVE_CONFIG_H -DNOT_RUBY -DEXPORT'
$regincpath = '../'
$regsrcpath = '../'
$regsrcs = Dir.glob('../*.c')
$regsrcs.delete('../testc.c')
$regsrcs.delete('../regex.c')
$reghdrs = Dir.glob('../*.h')
0.upto($regsrcs.size - 1) { |i|
  $regsrcs[i] = '../../' + File.basename($regsrcs[i])
}
0.upto($reghdrs.size - 1) { |i|
  $reghdrs[i] = '../../' + File.basename($reghdrs[i])
}
$regobjs = Array.new(0)
$regsrcs.each { |fname|
  $regobjs.push(File.basename(fname, '.c') + '.obj')
}
$encincpath='../enc'
$encsrcpath='../enc'
$encsrcs = Dir.glob('../enc/*.c')
$enchdrs = Dir.glob('../enc/*.h')
0.upto($encsrcs.size - 1) { |i|
  $encsrcs[i] = '../../enc/' + File.basename($encsrcs[i])
}
0.upto($enchdrs.size - 1) { |i|
  $enchdrs[i] = '../../enc/' + File.basename($enchdrs[i])
}
$encobjs = Array.new(0)
$encsrcs.each { |fname|
  $encobjs.push(File.basename(fname, '.c') + '.obj')
}
FileUtils.mkpath('lib') if not File.exist?('lib')
FileUtils.mkpath('dll') if not File.exist?('dll')
FileUtils.mkpath('include') if not File.exist?('include')
system("COPY ..\\oniguruma.h include")
system("COPY ..\\onigposix.h include")
system("COPY oniglink.h include")
system("COPY ..\\win32\\config.h .")
system("COPY ..\\win32\\testc.c .")
system("DEL /F testc.out")
$runtime.each { |dname|
  FileUtils.mkpath(dname) if not File.exist?(dname)
  io = open(dname + '/Makefile', 'w')
  io.printf("CFLAGS=%s -I..\\ -I..\\..\\ -I..\\..\\enc /O2 /W3 /%s\n", 
   $defs, dname)
  io.printf("ARLIB=LINK /LIB\n")
  io.printf("ARLIBFLAGS=\n")
  io.printf("LIBNAME=onig_s_%s.lib\n", dname)
  io.printf("ARDLL=CL /LD\n")
  io.printf("ARDLLFLAGS=\n")
  io.printf("DLLNAME=onig_%s.dll\n", dname)
  io.printf("REGHDRS=%s\n", makeline($reghdrs))
  io.printf("REGSRCS=%s\n", makeline($regsrcs))
  io.printf("REGOBJS=%s\n", makeline($regobjs))
  io.printf("ENCHDRS=%s\n", makeline($enchdrs))
  io.printf("ENCSRCS=%s\n", makeline($encsrcs))
  io.printf("ENCOBJS=%s\n", makeline($encobjs))
  io.printf("\n")
  io.printf("all:$(DLLNAME) $(LIBNAME)\n")
  io.printf("$(LIBNAME): $(REGOBJS) $(ENCOBJS)\n" + 
   "\t$(ARLIB) $(ARLIBFLAGS) /out:$@ $(REGOBJS) $(ENCOBJS)\n")
  io.printf("$(DLLNAME): $(REGOBJS) $(ENCOBJS)\n" + 
   "\t$(ARDLL) $(REGOBJS) $(ENCOBJS) /Fe$@ $(ARDLLFLAGS)\n")
  io.printf("\n")
  0.upto($regobjs.size - 1) { |i|
    io.printf("%s: %s $(REGHDRS) ..\\config.h\n", 
     $regobjs[i], $regsrcs[i].gsub(/\//, '\\'))
    io.printf("\t$(CC) $(CFLAGS) /c %s\n", 
     $regsrcs[i].gsub(/\//, '\\'))
    io.printf("\n")
  }
  0.upto($encobjs.size - 1) { |i|
    io.printf("%s: %s $(ENCHDRS) ..\\config.h\n", 
     $encobjs[i], $encsrcs[i].gsub(/\//, '\\'))
    io.printf("\t$(CC) $(CFLAGS) /c %s\n", 
     $encsrcs[i].gsub(/\//, '\\'))
    io.printf("\n")
  }
  io.close
  system(sprintf("cd %s& nmake", dname))
  system(sprintf("COPY %s\\*.lib lib", dname))
  system(sprintf("COPY %s\\*.dll dll", dname))
  system(sprintf("CL -D ONIG_EXTERN=extern /%s -I include " +
   "/Fetestc.exe testc.c " +
   "/link /libpath:lib onig_s_%s.lib",
   dname, dname))
  system("testc.exe >> testc.out")
  system("CL -D ONIG_EXTERN=extern -D POSIX_TEST /%s -I include " +
   "/Fetestc.exe testc.c " +
   "/link /libpath:lib onig_s_%s.lib", dname, dname)
  system("testc.exe >> testc.out")
  system("DEL /F *.ex? *.lib *.obj")
}
