//*****************************************************************************//
//fridge.h
//Copyright (C) 2006 K.Tsuchiya all rights reserved.
//2006/09/4
//... fridge library.
//
//## Coding fridge object in C-Language##
//1.fridge object function type in C-Language
// >>> fgData objname(fgHandle fhdl,int self);
// "fgData" is base data type in fridge. 
// typedef struct{
//     int type, //data type(int|double|str|object)
//     fgDataElm elm, //data element
// }fgData;
//
//2.Access fgData
// fgGetDataType(data) //getting data type (int)
// fgGetValInt(data)   //integer data
// fgGetValFlt(data)   //floating point data
// fgGetValStr(data)   //string data
// fgGetValObj(data)   //int data
// fgSetDataType(data,value) //setting data type
// fgSetValInt(data,value)
// fgSetValFlt(data,value)
// fgSetValStr(data,value)
// fgSetValObj(data,value)
// ###data tyep###
// fgDataTypeInt == 0 (integer data)
// fgDataTypeflt == 1 (floating point data)
// fgDataTypestr == 2 (string data)
// fgDataTypeInt == 3 (object data)
//
//3.Access object
// 3.1 char* fgGetName(fgHandle fhdl,int self);
// #getting object name
// 3.2 int fgMakeObj(fgHandle fhdl,char*objname,int super);
// # making(or finding) object.
// 3.3 int fgGetObj(fgHandle fhdl,int self,char*objname);
// # getting object value
// 3.4 int fgSetObj(fgHandle fhdl,int self,char*objname,fgData val);
// # setting object value
// 3.5 fgSetMeth(fgHandle fhdl,int self,fgData (*meth)(fgHandle,int));
// #setting method
// 3.6 fgData fgMethod(fgHandle fhdl,int self);
// #running object method
// 3.7 fgData fgSysCast(fgHandle fhdl,fgData data,int type);
// #casting data type
// 3.8 fgObj* fgGetObjLow(fgHandle fhdl,int id);
// #getting object pointer
//
//4.Access argumet values
// int fgGetArgSize(fgHandle fhdl,int self);//get argument size
// fgData fgGetArgElm(fgHandle fhdl,int self,int index);//get argument value
//
//5.Access array object
// fgData fgGetArry(fgHandle fhdl,int self,fgData index);
// fgData fgSetArry(fgHandle fhdl,int self,fgData index,fgData value);
// fgData fgGetArryNum(fgHandle fhdl,int self,int index);
// fgData fgSetArryNum(fgHandle fhdl,int self,int index,fgData value);
// #"index" is int or float or string.
//
//6.default object name (used by system)
// fgDefSuper : super object
// fgDefValue : constant value object
// fgDefSize  : array size object
// fgDefArg   : argument value object
//
//*****************************************************************************//

#ifndef __FRIDGE_HEAD
#define __FRIDGE_HEAD
#include "fgraph.h"
#include "fgsysobj.h"
#include "fridge.tab.h"

extern int fgParse(fgHandle inhdl,int argc,char**argv);

/*public function*/
#define fgIni    fgGraphIni
#define fgDes    fgGraphDes
#define fgMain   fgParse
#define fgSetAsk fgAskRootSet

#define fgVersion "0.13.26b"

/*standard library access*/
extern void* fgStdMethod(char*name,int flg,void*val);

/*fridge standard library */
extern fgData fgStdObjOpen(fgHandle fhdl,int self);//open device
extern fgData fgStdObjClose(fgHandle fhdl,int self);//close device
extern fgData fgStdObjRead(fgHandle fhdl,int self);//read from device
extern fgData fgStdObjReadln(fgHandle fhdl,int self);//read line from device
extern fgData fgStdObjWrite(fgHandle fhdl,int self);//write to device
extern fgData fgStdObjSystem(fgHandle fhdl,int self);//system("...")
extern fgData fgStdObjEcho(fgHandle fhdl,int self);//puts(" ")
extern fgData fgStdObjLen(fgHandle fhdl,int self);//string length
extern fgData fgStdObjSplit(fgHandle fhdl,int self);//string split
extern fgData fgStdObjSlice(fgHandle fhdl,int self);//string slice
extern fgData fgStdObjMatch(fgHandle fhdl,int self);//match regex
extern fgData fgStdObjReplace(fgHandle fhdl,int self);//replace regex
extern fgData fgStdObjPwrite(fgHandle fhdl,int self);//pipe write
extern fgData fgStdObjPread(fgHandle fhdl,int self);//pipe read
extern fgData fgStdObjMatch(fgHandle fhdl,int self);//regex match
extern fgData fgStdObjRslice(fgHandle fhdl,int self);//regex slice
extern fgData fgStdObjRreplace(fgHandle fhdl,int self);//regex replace
extern char* fgStdEscape(char* str);
#endif

