/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.util;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.sourceforge.freegantt.data.serializer.FileFormatException;
import jp.sourceforge.freegantt.util.CalendarUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static Element createDimensionElement(Document doc, String tagName, Dimension dim) {
        Element element = doc.createElement(tagName);
        Element width = doc.createElement("width");
        width.appendChild(doc.createTextNode(String.valueOf((int)dim.getWidth())));
        element.appendChild(width);
        Element height = doc.createElement("height");
        height.appendChild(doc.createTextNode(String.valueOf((int)dim.getHeight())));
        element.appendChild(height);
        return element;
    }

    public static Element createTextElement(Document doc, String tagName, String text) {
        Element element = doc.createElement(tagName);
        element.appendChild(doc.createTextNode(text));
        return element;
    }

    public static List<Element> getChildElements(Element ele) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList childNodes = ele.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i) instanceof Element) {
                elements.add((Element)childNodes.item(i));
            }
            ++i;
        }
        return elements;
    }

    public static Element getFirstElementByTag(Element ele, String tagName) {
        NodeList nodeList = ele.getElementsByTagName(tagName);
        if (nodeList.getLength() == 0) {
            return null;
        }
        Node node = nodeList.item(0);
        return node instanceof Element ? (Element)node : null;
    }

    public static List<String> getTextsByTagName(Element ele, String tagName) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nodeList = ele.getElementsByTagName(tagName);
        int i = 0;
        while (i < nodeList.getLength()) {
            result.add(nodeList.item(i).getTextContent());
            ++i;
        }
        return result;
    }

    public static Dimension getDimensionByTagName(Element ele, String tagName) throws FileFormatException {
        NodeList nodeList = ele.getElementsByTagName(tagName);
        if (nodeList.getLength() == 0 || !(nodeList.item(0) instanceof Element)) {
            throw new FileFormatException("tagName " + tagName + "has not found.");
        }
        Dimension dim = new Dimension();
        try {
            dim.width = Integer.parseInt(XmlUtil.getTextByTagName((Element)nodeList.item(0), "width"));
            dim.height = Integer.parseInt(XmlUtil.getTextByTagName((Element)nodeList.item(0), "height"));
            return dim;
        }
        catch (NumberFormatException e) {
            throw new FileFormatException("tagName " + tagName + "has number format error.");
        }
    }

    public static Dimension getDimensionByTagName(Element ele, String tagName, Dimension defaultValue) {
        try {
            return XmlUtil.getDimensionByTagName(ele, tagName);
        }
        catch (FileFormatException e) {
            return defaultValue;
        }
    }

    public static Calendar getCalendarByTagName(Element ele, String tagName) throws FileFormatException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(XmlUtil.getLongByTagName(ele, tagName));
        return CalendarUtil.toDateCalendar(calendar);
    }

    public static Calendar getCalendarByTagName(Element ele, String tagName, Calendar defaultValue) throws FileFormatException {
        try {
            return XmlUtil.getCalendarByTagName(ele, tagName);
        }
        catch (FileFormatException e) {
            return CalendarUtil.toDateCalendar(defaultValue);
        }
    }

    public static Long getLongByTagName(Element ele, String tagName) throws FileFormatException {
        return Long.parseLong(XmlUtil.getTextByTagName(ele, tagName));
    }

    public static Long getLongByTagName(Element ele, String tagName, Long defaultValue) throws FileFormatException {
        try {
            return XmlUtil.getLongByTagName(ele, tagName);
        }
        catch (FileFormatException e) {
            return defaultValue;
        }
    }

    public static Integer getIntegerByTagName(Element ele, String tagName) throws FileFormatException {
        return Integer.parseInt(XmlUtil.getTextByTagName(ele, tagName));
    }

    public static Integer getIntegerByTagName(Element ele, String tagName, Integer defaultValue) throws FileFormatException {
        try {
            return XmlUtil.getIntegerByTagName(ele, tagName);
        }
        catch (FileFormatException e) {
            return defaultValue;
        }
    }

    public static Double getDoubleByTagName(Element ele, String tagName) throws FileFormatException {
        return Double.parseDouble(XmlUtil.getTextByTagName(ele, tagName));
    }

    public static Double getDoubleByTagName(Element ele, String tagName, Double defaultValue) throws FileFormatException {
        try {
            return XmlUtil.getDoubleByTagName(ele, tagName);
        }
        catch (FileFormatException e) {
            return defaultValue;
        }
    }

    public static Boolean getBooleanByTagName(Element ele, String tagName) throws FileFormatException {
        return Boolean.parseBoolean(XmlUtil.getTextByTagName(ele, tagName));
    }

    public static Boolean getBooleanByTagName(Element ele, String tagName, Boolean defaultValue) throws FileFormatException {
        try {
            return XmlUtil.getBooleanByTagName(ele, tagName);
        }
        catch (FileFormatException e) {
            return defaultValue;
        }
    }

    public static String getTextByTagName(Element ele, String tagName) throws FileFormatException {
        NodeList nodeList = ele.getElementsByTagName(tagName);
        if (nodeList.getLength() == 0) {
            throw new FileFormatException("tagName " + tagName + " has not found.");
        }
        return nodeList.item(0).getTextContent();
    }

    public static String getTextByTagName(Element ele, String tagName, String defaultValue) {
        try {
            return XmlUtil.getTextByTagName(ele, tagName);
        }
        catch (FileFormatException e) {
            return defaultValue;
        }
    }

    public static List<Element> getElementsByTagName(Element ele, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList foundNodes = ele.getElementsByTagName(tagName);
        int i = 0;
        while (i < foundNodes.getLength()) {
            Node foundNode = foundNodes.item(i);
            if (foundNode instanceof Element) {
                list.add((Element)foundNode);
            }
            ++i;
        }
        return list;
    }
}

