/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.util;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class GraphicsUtil {
    public static void drawRect(Graphics g, int x, int y, int width, int height) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        BasicStroke stroke = new BasicStroke(1.0f, 2, 0);
        Rectangle2D.Double rect = new Rectangle2D.Double((double)x + 0.5, (double)y + 0.5, (double)width + 0.5, (double)height + 0.5);
        g2d.setStroke(stroke);
        g2d.draw(rect);
    }

    public static void drawStringLeft(Graphics g, String str, int x, int y, int width, int height) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics metrics = g.getFontMetrics();
        float adjustedX = (float)x + 1.0f;
        float adjustedY = (float)y + (float)metrics.getAscent() + (float)(height - metrics.getHeight()) / 2.0f;
        g2d.drawString(str, adjustedX, adjustedY);
    }

    public static void drawStringCenter(Graphics g, String str, int x, int y, int width, int height) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics metrics = g.getFontMetrics();
        int stringWidth = metrics.stringWidth(str);
        float adjustedX = (float)x + (float)(width - stringWidth) / 2.0f;
        float adjustedY = (float)y + (float)metrics.getAscent() + (float)(height - metrics.getHeight()) / 2.0f;
        g2d.drawString(str, adjustedX, adjustedY);
    }

    public static void drawScaledDate(Graphics g, String str, int x, int y, int width, int height, double scaleX) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (str.length() == 1) {
            GraphicsUtil.drawStringCenter(g, str, x, y, width, height);
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int stringWidth = metrics.stringWidth(str);
        int adjustedX = (int)((double)x / scaleX) + ((int)((double)width / scaleX) - stringWidth) / 2;
        int adjustedY = y + metrics.getAscent() + (height - metrics.getHeight()) / 2;
        AffineTransform oldTransform = g2d.getTransform();
        AffineTransform newTransform = (AffineTransform)oldTransform.clone();
        newTransform.scale(scaleX, 1.0);
        g2d.setTransform(newTransform);
        g2d.drawString(str, adjustedX, adjustedY);
        g2d.setTransform(oldTransform);
    }
}

