/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.undo.CompoundEdit;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.CursorState;
import jp.sourceforge.freegantt.swing.TaskLinePane;
import jp.sourceforge.freegantt.util.CalendarUtil;
import jp.sourceforge.freegantt.util.GraphicsUtil;

public class TaskLineHeaderPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 4416176242747877014L;
    public static final int OPERATION_NONE = 0;
    public static final int OPERATION_FREE_SCROLL = 1;
    Application app;
    TaskLinePane taskLinePane;
    CursorState cursorState;
    FreeScrollUI freeScrollUI;
    int dragOperation = 0;
    Color lineColor = new Color(192, 192, 192);
    Color bgColor = Color.white;
    Color fontColor = Color.black;

    public TaskLineHeaderPane(Application app, TaskLinePane taskLinePane) {
        this.app = app;
        this.taskLinePane = taskLinePane;
        this.cursorState = new CursorState(this);
        this.freeScrollUI = new FreeScrollUI();
        this.setBackground(this.bgColor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private int getCellHeight() {
        return this.taskLinePane.getCellHeight();
    }

    private int getCellWidth() {
        return this.taskLinePane.getCellWidth();
    }

    public void updateWidth() {
        Calendar fromDate = this.taskLinePane.getChartFromDate();
        Calendar toDate = this.taskLinePane.getChartToDate();
        this.setSize(CalendarUtil.subDate(toDate, fromDate) * this.getCellWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.lineColor);
        g.drawLine(0, this.getCellHeight() - 1, this.getWidth(), this.getCellHeight() - 1);
        g.drawLine(0, this.getCellHeight() * 2 - 1, this.getWidth(), this.getCellHeight() * 2 - 1);
        Calendar now = (Calendar)this.taskLinePane.getChartFromDate().clone();
        Calendar to = this.taskLinePane.getChartToDate();
        int offset = 0;
        SimpleDateFormat format = new SimpleDateFormat(Resource.get("chartHeaderMonth"), Resource.getLocale());
        while (now.getTimeInMillis() < to.getTimeInMillis()) {
            String text;
            if (this.app.getProject().isCalendarModeDate()) {
                g.setColor(this.fontColor);
                if (now.get(5) == 1) {
                    text = format.format(now.getTime());
                    GraphicsUtil.drawStringLeft(g, text, offset, 0, this.getCellWidth(), this.getCellHeight());
                }
                GraphicsUtil.drawScaledDate(g, String.valueOf(now.get(5)), offset, this.getCellHeight(), this.getCellWidth(), this.getCellHeight(), 0.7);
                now.add(5, 1);
                offset += this.getCellWidth();
                g.setColor(this.lineColor);
                if (now.get(5) == 1) {
                    g.drawLine(offset - 1, 0, offset - 1, this.getHeight() - 1);
                    continue;
                }
                g.drawLine(offset - 1, this.getCellHeight() - 1, offset - 1, this.getCellHeight() * 2 - 1);
                continue;
            }
            g.setColor(this.fontColor);
            if (now.get(5) == 1) {
                text = format.format(now.getTime());
                GraphicsUtil.drawStringLeft(g, text, offset, 0, this.getCellWidth(), this.getCellHeight());
            }
            if (now.get(7) == 2) {
                GraphicsUtil.drawScaledDate(g, String.valueOf(now.get(5)), offset, this.getCellHeight(), this.getCellWidth(), this.getCellHeight(), 0.7);
            }
            now.add(5, 1);
            offset += this.getCellWidth();
            g.setColor(this.lineColor);
            if (now.get(5) == 1) {
                g.drawLine(offset - 1, 0, offset - 1, this.getCellHeight() - 1);
            }
            if (now.get(7) != 2) continue;
            g.drawLine(offset - 1, this.getCellHeight() - 1, offset - 1, this.getCellHeight() * 2 - 1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && this.freeScrollUI.mousePressed(e)) {
            return;
        }
        if (e.isPopupTrigger() && e.getY() >= this.getCellHeight()) {
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.freeScrollUI.mouseReleased(e)) {
            return;
        }
        if (e.isPopupTrigger() && e.getY() >= this.getCellHeight()) {
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.freeScrollUI.mouseDragged(e)) {
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private Calendar getCalendarAtPoint(Point p) {
        long offsetDate = p.x / this.getCellWidth();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.taskLinePane.getChartFromDate().getTimeInMillis() + offsetDate * 86400000L);
        return calendar;
    }

    private void triggerPopup(MouseEvent e) {
        final Calendar calendar = this.getCalendarAtPoint(e.getPoint());
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Resource.get("chartHeaderAddHoliday"));
        item.setEnabled(!this.app.getProject().isHoliday(calendar));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompoundEdit compound = new CompoundEdit();
                TaskLineHeaderPane.this.app.getProject().getUndoManager().addEdit(compound);
                try {
                    TaskLineHeaderPane.this.app.getProject().getController().addAdditionalHoliday(calendar);
                    TaskLineHeaderPane.this.app.getProject().update();
                }
                finally {
                    compound.end();
                }
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("chartHeaderRemoveHoliday"));
        item.setEnabled(this.app.getProject().isAdditionalHoliday(calendar));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompoundEdit compound = new CompoundEdit();
                TaskLineHeaderPane.this.app.getProject().getUndoManager().addEdit(compound);
                try {
                    TaskLineHeaderPane.this.app.getProject().getController().removeAdditionalHoliday(calendar);
                    TaskLineHeaderPane.this.app.getProject().update();
                }
                finally {
                    compound.end();
                }
            }
        });
        menu.add(item);
        menu.show(this, e.getX(), e.getY());
    }

    class FreeScrollUI {
        Point dragStartPoint;
        Point freeScrollStartPoint;

        FreeScrollUI() {
        }

        public boolean mousePressed(MouseEvent e) {
            this.dragStartPoint = e.getLocationOnScreen();
            this.freeScrollStartPoint = new Point(TaskLineHeaderPane.this.app.getTaskLineRootPane().getHorizontalScrollBar().getValue(), 0);
            TaskLineHeaderPane.this.dragOperation = 1;
            TaskLineHeaderPane.this.cursorState.setCursor(12);
            return true;
        }

        public boolean mouseDragged(MouseEvent e) {
            if (TaskLineHeaderPane.this.dragOperation == 1) {
                Point pressPoint = e.getLocationOnScreen();
                Dimension moveDistance = new Dimension(pressPoint.x - this.dragStartPoint.x, pressPoint.y - this.dragStartPoint.y);
                JScrollBar hbar = TaskLineHeaderPane.this.app.getTaskLineRootPane().getHorizontalScrollBar();
                int hvalue = this.freeScrollStartPoint.x - moveDistance.width;
                hvalue = Math.min(hbar.getMaximum() - hbar.getVisibleAmount() - 1, Math.max(1, hvalue));
                hbar.setValue(hvalue);
                return true;
            }
            return false;
        }

        public boolean mouseReleased(MouseEvent e) {
            if (TaskLineHeaderPane.this.dragOperation == 1) {
                TaskLineHeaderPane.this.dragOperation = 0;
                TaskLineHeaderPane.this.cursorState.setDefaultCursor();
                return true;
            }
            return false;
        }
    }
}

