/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableColumn;
import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.model.ProjectViewChangedListener;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskListTable;

public class GanttChartSplitPane
extends JSplitPane {
    private static final long serialVersionUID = -8567327389185691533L;
    Application app;
    int openedDividerLocation = 0;
    int columnStickWidth = 8;

    public GanttChartSplitPane(Application app, int newOrientation) {
        super(newOrientation);
        this.app = app;
        GanttChartSplitPaneUI ui = new GanttChartSplitPaneUI();
        this.setUI(ui);
        ui.getDivider().addMouseListener(new DividerMouseListener());
        this.addPropertyChangeListener(new DividerLocationChangeListener());
        app.getProject().getProjectViewModel().addProjectViewChangedListener(new ProjectViewChangedHandler());
    }

    @Override
    public void setDividerLocation(int location) {
        super.setDividerLocation(location);
        this.app.getProject().getView().setTaskTableWidth(location);
        if (location > 10) {
            this.openedDividerLocation = location;
        }
    }

    @Override
    public int getMaximumDividerLocation() {
        int width = 48;
        for (Column column : this.app.getProject().getView().getColumns()) {
            width += column.getWidth();
        }
        return width <= 48 ? 0 : width;
    }

    class DividerLocationChangeListener
    implements PropertyChangeListener {
        DividerLocationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dividerLocation")) {
                int maximumDividerLocation = GanttChartSplitPane.this.getMaximumDividerLocation();
                if ((Integer)evt.getNewValue() > maximumDividerLocation) {
                    GanttChartSplitPane.this.setDividerLocation(maximumDividerLocation);
                    return;
                }
                TaskListTable table = GanttChartSplitPane.this.app.getTaskListTable();
                if (table == null) {
                    return;
                }
                ArrayList<TableColumn> columns = Collections.list(table.getColumnModel().getColumns());
                int width = 18;
                for (TableColumn column : columns) {
                    if ((Integer)evt.getNewValue() < (width += column.getWidth()) - GanttChartSplitPane.this.columnStickWidth || (Integer)evt.getNewValue() > width + GanttChartSplitPane.this.columnStickWidth) continue;
                    GanttChartSplitPane.this.setDividerLocation(width);
                }
            }
        }
    }

    class DividerMouseListener
    implements MouseListener {
        int preDividerLocation = 0;

        DividerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int newLocation = GanttChartSplitPane.this.getDividerLocation() < 10 ? GanttChartSplitPane.this.openedDividerLocation : 0;
                GanttChartSplitPane.this.app.getProject().getController().setTaskTableWidth(GanttChartSplitPane.this.app.getProject(), this.preDividerLocation, newLocation);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.preDividerLocation = GanttChartSplitPane.this.getDividerLocation();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.preDividerLocation != GanttChartSplitPane.this.getDividerLocation()) {
                GanttChartSplitPane.this.app.getProject().getController().setTaskTableWidth(GanttChartSplitPane.this.app.getProject(), this.preDividerLocation, GanttChartSplitPane.this.getDividerLocation());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class GanttChartSplitPaneUI
    extends BasicSplitPaneUI {
        GanttChartSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider getDivider() {
            return this.divider;
        }
    }

    class ProjectViewChangedHandler
    implements ProjectViewChangedListener {
        ProjectViewChangedHandler() {
        }

        @Override
        public void projectViewChanged() {
            GanttChartSplitPane.this.setDividerLocation(GanttChartSplitPane.this.app.getProject().getView().getTaskTableWidth());
        }
    }
}

