/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jp.sourceforge.freegantt.data.model.ProjectViewChangedListener;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.GanttChartSplitPane;
import jp.sourceforge.freegantt.swing.TaskLineRootPane;
import jp.sourceforge.freegantt.swing.TaskListRootPane;

public class GanttChartPane
extends JPanel {
    private static final long serialVersionUID = -968483593747003051L;
    Application app;
    GanttChartSplitPane ganttChartSplitPane;
    TaskLineRootPane taskLineRootPane;
    TaskListRootPane taskListRootPane;

    public GanttChartPane(Application app) {
        super(new BorderLayout());
        this.app = app;
        this.setBackground(Color.blue);
        app.getProject().getProjectViewModel().addProjectViewChangedListener(new ProjectViewChangedHandler());
        this.ganttChartSplitPane = new GanttChartSplitPane(app, 1);
        this.ganttChartSplitPane.setBounds(0, 0, 300, 200);
        this.ganttChartSplitPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.ganttChartSplitPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.ganttChartSplitPane.setDividerSize(4);
        this.ganttChartSplitPane.setContinuousLayout(true);
        this.add((Component)this.ganttChartSplitPane, "Center");
        this.taskListRootPane = new TaskListRootPane(app);
        this.taskListRootPane.setBounds(0, 0, 100, 200);
        this.taskListRootPane.setMinimumSize(new Dimension(0, 0));
        this.ganttChartSplitPane.add(this.taskListRootPane);
        this.taskLineRootPane = new TaskLineRootPane(app);
        this.taskLineRootPane.setBounds(0, 0, 500, 200);
        this.taskLineRootPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ganttChartSplitPane.add(this.taskLineRootPane);
        this.ganttChartSplitPane.setDividerLocation(app.getProject().getView().getTaskTableWidth());
        this.updateDividerLocation();
    }

    public TaskLineRootPane getTaskLineRootPane() {
        return this.taskLineRootPane;
    }

    public TaskListRootPane getTaskListRootPane() {
        return this.taskListRootPane;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.ganttChartSplitPane.setSize(this.getSize());
    }

    public void updateDividerLocation() {
        int max = this.ganttChartSplitPane.getMaximumDividerLocation();
        if (this.ganttChartSplitPane.getDividerLocation() > max) {
            int oldLocation = this.ganttChartSplitPane.getDividerLocation();
            this.ganttChartSplitPane.setDividerLocation(max);
            this.app.getProject().getController().setTaskTableWidth(this.app.getProject(), oldLocation, max);
        }
    }

    class ProjectViewChangedHandler
    implements ProjectViewChangedListener {
        ProjectViewChangedHandler() {
        }

        @Override
        public void projectViewChanged() {
            GanttChartPane.this.updateDividerLocation();
        }
    }
}

