/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.print.PreviewDialog;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.MenuItemBorder;

public class PreviewIconMenu
extends JPanel {
    private static final long serialVersionUID = -124013620119721993L;
    Application app;
    PreviewDialog dialog;
    JLabel pageLabel;
    JButton prevPageButton;
    JButton postPageButton;

    public JLabel getPageLabel() {
        return this.pageLabel;
    }

    public JButton getPrevPageButton() {
        return this.prevPageButton;
    }

    public JButton getPostPageButton() {
        return this.postPageButton;
    }

    public PreviewIconMenu(final Application app, final PreviewDialog dialog) {
        this.app = app;
        this.dialog = dialog;
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(2);
        layout.setHgap(2);
        this.setLayout(layout);
        this.setPreferredSize(new Dimension(Integer.MAX_VALUE, 28));
        this.add(this.createButton(Resource.get("previewPage"), "menuFilePage.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.configurePage();
                dialog.updatePageFormat(app.getProject().getPrint().getPageFormat());
                dialog.renderPage(dialog.getPage());
            }
        }));
        this.add(this.createButton(Resource.get("previewPrint"), "menuFilePrint.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.print();
            }
        }));
        this.add(new Sepalator());
        this.prevPageButton = this.createButton(Resource.get("previewPrevPage"), "previewPrevPage.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setPage(Math.max(0, dialog.getPage() - 1));
                dialog.updatePage();
                dialog.renderPage(dialog.getPage());
            }
        });
        this.add(this.prevPageButton);
        this.pageLabel = new JLabel();
        this.add(this.pageLabel);
        this.postPageButton = this.createButton(Resource.get("previewPostPage"), "previewPostPage.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setPage(Math.min(dialog.getPageCount() - 1, dialog.getPage() + 1));
                dialog.updatePage();
                dialog.renderPage(dialog.getPage());
            }
        });
        this.add(this.postPageButton);
        this.add(new Sepalator());
        this.add(this.createButton(Resource.get("previewClose"), "previewClose.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        }));
    }

    public JButton createButton(String tooltip, String filename, ActionListener listener) {
        JButton button = new JButton();
        button.setUI(new BasicButtonUI());
        button.setBorder(new MenuItemBorder());
        System.out.println(filename);
        button.setIcon(new ImageIcon(this.getClass().getResource(filename)));
        button.addActionListener(listener);
        button.setPreferredSize(new Dimension(24, 24));
        button.setToolTipText(tooltip);
        return button;
    }

    class Sepalator
    extends JPanel {
        private static final long serialVersionUID = 5819409774260437397L;

        public Sepalator() {
            this.setPreferredSize(new Dimension(9, 24));
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.gray);
            g.drawLine(4, 1, 4, this.getHeight() - 2);
        }
    }
}

