/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.print.GanttChartPrintable;
import jp.sourceforge.freegantt.print.PreviewIconMenu;
import jp.sourceforge.freegantt.print.PreviewMenu;
import jp.sourceforge.freegantt.swing.Application;

public class PreviewDialog
extends JDialog {
    private static final long serialVersionUID = 6695686076348590807L;
    Application app;
    PageFormat pageFormat;
    int page = 0;
    int pageCount = 0;
    BufferedImage image;
    PreviewIconMenu itemMenuPanel;
    ImagePanel imagePanel;

    public PreviewDialog(Application app) {
        super((Frame)app, true);
        this.app = app;
        this.imagePanel = new ImagePanel();
        this.imagePanel.setBounds(0, 0, 100, 100);
        this.imagePanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.getContentPane().add((Component)this.imagePanel, "Center");
        this.setTitle(Resource.get("previewTitle"));
        this.setSize(640, 480);
        this.setIconImage(app.getApplicationIconImage());
        this.itemMenuPanel = new PreviewIconMenu(app, this);
        this.getContentPane().add((Component)this.itemMenuPanel, "North");
        this.setJMenuBar(new PreviewMenu(app, this));
        this.pageCount = app.getTaskLineDataPane().getPrintRange().getPrintRanges().size();
        this.updatePageFormat(app.getProject().getPrint().getPageFormat());
        this.updatePage();
        this.renderPage(this.page);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void updatePageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.image = new BufferedImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight(), 4);
        Graphics g = null;
        try {
            g = this.image.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.image.getWidth(this), this.image.getHeight(this));
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        this.imagePanel.setImage(this.image);
        this.repaint();
    }

    public void renderPage(int pageIndex) {
        block8: {
            GanttChartPrintable printable = new GanttChartPrintable(this.app);
            Graphics g = null;
            try {
                try {
                    g = this.image.getGraphics();
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.image.getWidth(this), this.image.getHeight(this));
                    printable.print(g, this.pageFormat, pageIndex);
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                    if (g != null) {
                        g.dispose();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (g != null) {
                    g.dispose();
                }
                throw throwable;
            }
            if (g != null) {
                g.dispose();
            }
        }
        this.imagePanel.repaint();
    }

    public void updatePage() {
        this.itemMenuPanel.getPageLabel().setText(Math.min(this.page + 1, this.pageCount) + " / " + this.pageCount);
        this.itemMenuPanel.getPrevPageButton().setEnabled(this.page > 0);
        this.itemMenuPanel.getPostPageButton().setEnabled(this.page < this.pageCount - 1);
    }

    class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 7267024727103791877L;
        Image image;

        ImagePanel() {
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image == null) {
                return;
            }
            double scaleX = (double)this.getWidth() / (double)this.image.getWidth(this);
            double scaleY = (double)this.getHeight() / (double)this.image.getHeight(this);
            double scale = Math.min(scaleX, scaleY);
            int scaledWidth = (int)((double)this.image.getWidth(this) * scale);
            int scaledHeight = (int)((double)this.image.getHeight(this) * scale);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            AffineTransform transform = new AffineTransform();
            transform.translate((this.getWidth() - scaledWidth) / 2, (this.getHeight() - scaledHeight) / 2);
            transform.scale(scale, scale);
            g2d.drawImage(this.image, transform, this);
        }
    }
}

