/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class UpdateTaskEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4925123071826232873L;
    Project project;
    int index;
    Task oldTask;
    Task newTask;
    List<Integer> oldRestrictionIndexes;
    List<Integer> newRestrictionIndexes;

    public UpdateTaskEdit(Project project, Task newTask, int index) {
        this.project = project;
        this.index = index;
        this.oldTask = project.getTaskAtIndex(index).clone();
        this.newTask = newTask.clone();
        this.oldRestrictionIndexes = project.collectRestrictionIndexes(this.oldTask);
        this.newRestrictionIndexes = project.collectRestrictionIndexes(newTask);
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().setTaskAtIndex(this.oldTask, this.index);
        this.oldTask.setRestrictions(this.project.collectTasksAtIndexes(this.oldRestrictionIndexes));
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().setTaskAtIndex(this.newTask, this.index);
        this.newTask.setRestrictions(this.project.collectTasksAtIndexes(this.newRestrictionIndexes));
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldTask = null;
        this.newTask = null;
    }
}

