/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class RemoveMemberEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 6210197762255608085L;
    Project project;
    Member oldMember;
    int index;
    List<Integer> srcTasks = new ArrayList<Integer>();

    public RemoveMemberEdit(Project project, int index) {
        this.project = project;
        this.oldMember = project.getMembers().get(index);
        this.index = index;
        int i = 0;
        while (i < project.getTasks().size()) {
            Task task = project.getTasks().get(i);
            if (task.getMember() == this.oldMember) {
                this.srcTasks.add(i);
            }
            ++i;
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().addMember(this.oldMember, this.index);
        for (Integer index : this.srcTasks) {
            Task task = this.project.getTasks().get(index);
            task.setMember(this.oldMember);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().removeMember(this.index);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldMember = null;
        this.srcTasks = null;
    }
}

