/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.Calendar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;

public class RemoveAdditionalHolidayEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4680421507513488869L;
    Project project;
    Calendar oldCalendar;
    int index;

    public RemoveAdditionalHolidayEdit(Project project, int index) {
        this.project = project;
        this.index = index;
        this.oldCalendar = (Calendar)project.getAdditionalHolidays().get(index).clone();
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().addAdditionalHoliday(this.oldCalendar, this.index);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().removeAdditionalHoliday(this.index);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldCalendar = null;
    }
}

