/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class InsertTaskEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 6954579936773863317L;
    Project project;
    int index;
    Task newTask;
    List<Integer> newRestrictionIndexes;

    public InsertTaskEdit(Project project, Task newTask, int index) {
        this.project = project;
        this.index = index;
        this.newTask = newTask.clone();
        this.newRestrictionIndexes = project.collectRestrictionIndexes(newTask);
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        this.project.getController().removeIndex(this.index);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().insertTaskAtIndex(this.newTask, this.index);
        this.newTask.setRestrictions(this.project.collectTasksAtIndexes(this.newRestrictionIndexes));
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.newTask = null;
    }
}

