/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class CreateRestrictionEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -8271123013131982024L;
    Project project;
    int srcIndex;
    int dstIndex;

    public CreateRestrictionEdit(Project project, int srcIndex, int dstIndex) {
        this.project = project;
        this.srcIndex = srcIndex;
        this.dstIndex = dstIndex;
    }

    @Override
    public void undo() throws CannotUndoException {
        System.out.println("Undo " + this.getClass().toString());
        super.undo();
        Task srcTask = this.project.getTaskAtRow(this.srcIndex);
        Task dstTask = this.project.getTaskAtRow(this.dstIndex);
        this.project.getController().removeRestriction(srcTask, dstTask);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Task srcTask = this.project.getTaskAtRow(this.srcIndex);
        Task dstTask = this.project.getTaskAtRow(this.dstIndex);
        this.project.getController().addRestriction(srcTask, dstTask);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
    }
}

