/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.controller;

import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.util.Calendar;
import java.util.List;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.data.undo.CreateAdditionalHolidayEdit;
import jp.sourceforge.freegantt.data.undo.CreateMemberEdit;
import jp.sourceforge.freegantt.data.undo.CreateRestrictionEdit;
import jp.sourceforge.freegantt.data.undo.CreateTaskEdit;
import jp.sourceforge.freegantt.data.undo.InsertTaskEdit;
import jp.sourceforge.freegantt.data.undo.RemoveAdditionalHolidayEdit;
import jp.sourceforge.freegantt.data.undo.RemoveMemberEdit;
import jp.sourceforge.freegantt.data.undo.RemoveRestrictioinEdit;
import jp.sourceforge.freegantt.data.undo.RemoveTaskEdit;
import jp.sourceforge.freegantt.data.undo.UpdateAdditionalHolidayEdit;
import jp.sourceforge.freegantt.data.undo.UpdateCalendarModeEdit;
import jp.sourceforge.freegantt.data.undo.UpdateCellSizeEdit;
import jp.sourceforge.freegantt.data.undo.UpdateFixedHolidayEdit;
import jp.sourceforge.freegantt.data.undo.UpdateMemberEdit;
import jp.sourceforge.freegantt.data.undo.UpdateModifiedEdit;
import jp.sourceforge.freegantt.data.undo.UpdatePrintCellSizeEdit;
import jp.sourceforge.freegantt.data.undo.UpdateProjectNameEdit;
import jp.sourceforge.freegantt.data.undo.UpdateProjectSummaryEdit;
import jp.sourceforge.freegantt.data.undo.UpdateTaskCriticalPathEdit;
import jp.sourceforge.freegantt.data.undo.UpdateTaskEdit;
import jp.sourceforge.freegantt.data.undo.UpdateTaskGroupEdit;
import jp.sourceforge.freegantt.data.undo.UpdateTaskTableWidthEdit;
import jp.sourceforge.freegantt.data.undo.UpdateTaskVisibleEdit;
import jp.sourceforge.freegantt.data.undo.UpdateViewTaskTableColumnsEdit;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class ProjectController {
    Project project;

    public ProjectController(Project project) {
        this.project = project;
    }

    private UndoManager getUndoManager() {
        return this.project.getUndoManager();
    }

    public void setModified(boolean flag) {
        if (this.project.isModified() == flag) {
            return;
        }
        this.project.getUndoManager().addEdit(new UpdateModifiedEdit(this.project, flag));
        this.project.setModified(flag);
        this.project.getProjectModifiedModel().fireProjectModifiedEment();
    }

    public void removeIndex(int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            Task targetTask = this.project.getTaskAtIndex(index);
            this.removeDestRestrictions(targetTask);
            compound.addEdit(new RemoveTaskEdit(this.project, index));
            if (targetTask != null) {
                this.project.getTasks().remove(targetTask);
            }
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
        }
    }

    public void insertTaskAtIndex(Task newTask, int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            this.getUndoManager().addEdit(new InsertTaskEdit(this.project, newTask, index));
            this.project.getTasks().add(index, newTask);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
        }
    }

    public void setTaskAtIndex(Task newTask, int index) {
        if (newTask == null) {
            newTask = new Task();
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            this.fillNewTaskAtIndex(index);
            Task oldTask = this.project.getTaskAtIndex(index);
            for (Task task : this.project.getTasks()) {
                if (!task.getRestrictions().remove(oldTask)) continue;
                task.getRestrictions().add(newTask);
            }
            compound.addEdit(new UpdateTaskEdit(this.project, newTask, index));
            this.project.getTasks().set(index, newTask);
        }
        finally {
            compound.end();
        }
    }

    public Task fillNewTaskAtIndex(int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            while (this.project.getTasks().size() <= index) {
                Task fillTask = new Task();
                compound.addEdit(new CreateTaskEdit(this.project, fillTask));
                this.project.getTasks().add(fillTask);
            }
        }
        finally {
            compound.end();
        }
        return this.project.getTaskAtIndex(index);
    }

    public void addRestriction(Task src, Task dst) {
        CompoundEdit compound = new CompoundEdit();
        this.project.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new CreateRestrictionEdit(this.project, this.project.getIndexByTask(src), this.project.getIndexByTask(dst)));
            src.addRestriction(dst);
            this.project.getTaskTableModel().fireTableChanged();
        }
        finally {
            compound.end();
        }
    }

    public void removeRestriction(Task src, Task dst) {
        CompoundEdit compound = new CompoundEdit();
        this.project.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new RemoveRestrictioinEdit(this.project, this.project.getIndexByTask(src), this.project.getIndexByTask(dst)));
            src.removeRestriction(dst);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
        }
    }

    public void removeDestRestrictions(Task task) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            List<Task> srcs = this.project.getRestrictionSrcTasks(task);
            for (Task src : srcs) {
                compound.addEdit(new RemoveRestrictioinEdit(this.project, this.project.getIndexByTask(src), this.project.getIndexByTask(task)));
                src.getRestrictions().remove(task);
            }
        }
        finally {
            compound.end();
        }
    }

    public void removeSrcRestrictions(Task task) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            for (Task dst : task.getRestrictions()) {
                compound.addEdit(new RemoveRestrictioinEdit(this.project, this.project.getIndexByTask(task), this.project.getIndexByTask(dst)));
            }
            task.getRestrictions().clear();
        }
        finally {
            compound.end();
        }
    }

    public void levelUpTask(Task task) {
        if (task == null) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            int index = this.project.getIndexByTask(task);
            Task newTask = task.clone();
            newTask.setLevel(task.getLevel() + 1);
            this.setTaskAtIndex(newTask, index);
        }
        finally {
            compound.end();
        }
    }

    public void levelDownTask(Task task) {
        if (task == null) {
            return;
        }
        if (task.getLevel() <= 0) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            int index = this.project.getIndexByTask(task);
            Task newTask = task.clone();
            newTask.setLevel(task.getLevel() - 1);
            this.setTaskAtIndex(newTask, index);
        }
        finally {
            compound.end();
        }
    }

    public void setPrintCellSize(Dimension newPrintCellSize) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdatePrintCellSizeEdit(this.project, newPrintCellSize));
            this.project.getPrint().setPrintCellSize(newPrintCellSize);
        }
        finally {
            compound.end();
        }
    }

    public void setFixedHoliday(int week, boolean value) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateFixedHolidayEdit(this.project, week, value));
            if (value) {
                this.project.getFixedHolidays().remove(new Integer(week));
                this.project.getFixedHolidays().add(new Integer(week));
            } else {
                this.project.getFixedHolidays().remove(new Integer(week));
            }
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void addAdditionalHoliday(Calendar calendar, int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new CreateAdditionalHolidayEdit(this.project, calendar, index));
            this.project.getAdditionalHolidays().add(index, calendar);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void addAdditionalHoliday(Calendar calendar) {
        this.addAdditionalHoliday(calendar, this.project.getAdditionalHolidays().size());
    }

    public void removeAdditionalHoliday(int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new RemoveAdditionalHolidayEdit(this.project, index));
            this.project.getAdditionalHolidays().remove(index);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void removeAdditionalHoliday(Calendar calendar) {
        List<Calendar> holidays = this.project.getAdditionalHolidays();
        int i = 0;
        while (i < holidays.size()) {
            if (CalendarUtil.dateEquals(calendar, holidays.get(i))) {
                this.removeAdditionalHoliday(i);
                return;
            }
            ++i;
        }
    }

    public void setAdditionalHoliday(Calendar calendar, int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateAdditionalHolidayEdit(this.project, calendar, index));
            this.project.getAdditionalHolidays().get(index).setTime(calendar.getTime());
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getHolidayTableModel().fireTableChanged();
        }
    }

    public void addMember(Member member, int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            compound.addEdit(new CreateMemberEdit(this.project, member, index));
            this.project.getMembers().add(index, member);
        }
        finally {
            compound.end();
            this.project.getMemberTableModel().fireTableChanged();
            this.project.getTaskMemberComboBoxModel().fireListDataListener();
        }
    }

    public void removeMember(int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new RemoveMemberEdit(this.project, index));
            Member oldMember = this.project.getMembers().get(index);
            for (Task task : this.project.getTasks()) {
                if (task.getMember() != oldMember) continue;
                task.setMember(null);
            }
            this.project.getMembers().remove(index);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getMemberTableModel().fireTableChanged();
            this.project.getTaskMemberComboBoxModel().fireListDataListener();
        }
    }

    public void setMember(Member member, int index) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateMemberEdit(this.project, member, index));
            Member oldMember = this.project.getMembers().get(index);
            for (Task task : this.project.getTasks()) {
                if (task.getMember() != oldMember) continue;
                task.setMember(member);
            }
            this.project.getMembers().set(index, member);
        }
        finally {
            compound.end();
            this.project.getTaskTableModel().fireTableChanged();
            this.project.getMemberTableModel().fireTableChanged();
            this.project.getTaskMemberComboBoxModel().fireListDataListener();
        }
    }

    public void setName(String text) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateProjectNameEdit(this.project, text));
            this.project.setName(text);
        }
        finally {
            compound.end();
            this.project.getProjectInfoModel().fireProjectInfoChangedEvent();
        }
    }

    public void setSummary(String text) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateProjectSummaryEdit(this.project, text));
            this.project.setSummary(text);
        }
        finally {
            compound.end();
            this.project.getProjectInfoModel().fireProjectInfoChangedEvent();
        }
    }

    public void setPageFormat(Project project, PageFormat pageFormat) {
        project.getPrint().setPageFormat(pageFormat);
        project.setModified(true);
    }

    public void setTaskTableWidth(Project project, int oldDividerLocation, int dividerLocation) {
        if (oldDividerLocation == dividerLocation) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateTaskTableWidthEdit(project, oldDividerLocation, dividerLocation));
            project.getView().setTaskTableWidth(dividerLocation);
        }
        finally {
            compound.end();
            project.getProjectViewModel().fireProjectViewChangedEvent();
        }
    }

    public void setViewTaskTableColumns(Project project, List<Column> oldColumns, List<Column> newColumns) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateViewTaskTableColumnsEdit(project, oldColumns, newColumns));
            project.getView().setColumns(newColumns);
        }
        finally {
            compound.end();
            project.getProjectViewModel().fireProjectViewChangedEvent();
        }
    }

    public void setCellSize(Dimension cellSize) {
        if (cellSize.width < 6) {
            return;
        }
        if (cellSize.width > 20) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateCellSizeEdit(this.project, cellSize));
            this.project.setCellSize(cellSize);
        }
        finally {
            compound.end();
            this.project.getProjectViewModel().fireProjectViewChangedEvent();
        }
    }

    public void setCalendarMode(int mode) {
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            Dimension dim = (Dimension)this.project.getCellSize().clone();
            if (mode == 0) {
                dim.width += 4;
                this.setCellSize(dim);
            } else {
                dim.width -= 4;
                this.setCellSize(dim);
            }
            compound.addEdit(new UpdateCalendarModeEdit(this.project, mode));
            this.project.setCalendarMode(mode);
        }
        finally {
            compound.end();
            this.project.getProjectViewModel().fireProjectViewChangedEvent();
        }
    }

    public void setTaskGroup(boolean group, int index) {
        Task task = this.project.getTaskAtIndex(index);
        if (task == null) {
            return;
        }
        if (task.isGroup() == group) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateTaskGroupEdit(this.project, group, index));
            task.setGroup(group);
        }
        finally {
            compound.end();
        }
    }

    public void setTaskCriticalPath(boolean criticalPath, int index) {
        Task task = this.project.getTaskAtIndex(index);
        if (task == null) {
            return;
        }
        if (task.isCriticalPath() == criticalPath) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateTaskCriticalPathEdit(this.project, criticalPath, index));
            task.setCriticalPath(criticalPath);
        }
        finally {
            compound.end();
        }
    }

    public void setTaskVisible(boolean visible, int index) {
        Task task = this.project.getTaskAtIndex(index);
        if (task == null) {
            return;
        }
        if (task.isVisible() == visible) {
            return;
        }
        CompoundEdit compound = new CompoundEdit();
        this.getUndoManager().addEdit(compound);
        try {
            this.setModified(true);
            compound.addEdit(new UpdateTaskVisibleEdit(this.project, visible, index));
            task.setVisible(visible);
        }
        finally {
            compound.end();
        }
    }
}

