/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.sourceforge.freegantt.data.Member;

public class Task
implements Cloneable {
    String Name = "";
    Calendar startDate;
    Integer period;
    int completion;
    Member member;
    int level;
    List<Task> restrictions = new ArrayList<Task>();
    boolean visible = true;
    boolean opened = true;
    Integer realPeriod;
    boolean criticalPath = false;
    boolean group = false;

    public Task clone() {
        try {
            Task cloneTask = (Task)super.clone();
            cloneTask.restrictions = new ArrayList<Task>(this.restrictions);
            return cloneTask;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isCriticalPath() {
        return this.criticalPath;
    }

    public void setCriticalPath(boolean criticalPath) {
        this.criticalPath = criticalPath;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public List<Task> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<Task> restrictions) {
        this.restrictions = restrictions;
    }

    public Integer getRealPeriod() {
        return this.realPeriod;
    }

    public void setRealPeriod(Integer realPeriod) {
        this.realPeriod = realPeriod;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getCompletion() {
        return this.completion;
    }

    public void setCompletion(int completion) {
        this.completion = Math.min(Math.max(completion, 0), 100);
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean flag) {
        this.group = flag;
    }

    public boolean isMilestone() {
        return !(this.period != null && this.period != 0 || this.realPeriod != null && this.realPeriod != 0);
    }

    public boolean isDrawable() {
        return this.startDate != null;
    }

    public List<Task> getVisibleRestrictions() {
        ArrayList<Task> visibleTasks = new ArrayList<Task>();
        for (Task task : this.restrictions) {
            if (!task.isVisible()) continue;
            visibleTasks.add(task);
        }
        return visibleTasks;
    }

    public Calendar getEndDate() {
        if (this.startDate == null) {
            return null;
        }
        Calendar endDate = (Calendar)this.startDate.clone();
        if (this.realPeriod != null && this.realPeriod > 0) {
            endDate.add(5, this.realPeriod);
        }
        return endDate;
    }

    public void addRestriction(Task targetTask) {
        if (targetTask != this && !targetTask.getRestrictions().contains(this) && !this.getRestrictions().contains(targetTask)) {
            this.restrictions.add(targetTask);
        }
    }

    public void removeRestriction(Task targetTask) {
        this.restrictions.remove(targetTask);
    }
}

