/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;
import jp.sourceforge.freegantt.swing.Application;

public class HolidayTable
extends JTable {
    private static final long serialVersionUID = -4264344738836855169L;
    Color borderColor = new Color(192, 192, 192);
    Application app;

    public HolidayTable(Application app, TableModel dm) {
        super(dm);
        this.app = app;
        this.setFillsViewportHeight(true);
        this.setColumnSelectionAllowed(false);
        this.setGridColor(this.borderColor);
        this.getTableHeader().setResizingAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.registerKeyboardAction(new RemoveAction(), KeyStroke.getKeyStroke(127, 0), 0);
        this.registerKeyboardAction(app.getMenu().getUndoAction(), KeyStroke.getKeyStroke(90, 128), 0);
        this.registerKeyboardAction(app.getMenu().getRedoAction(), KeyStroke.getKeyStroke(89, 128), 0);
        this.getColumnModel().getColumn(0).setCellRenderer(this.getTableHeader().getDefaultRenderer());
        this.columnModel.getColumn(0).setPreferredWidth(32);
        this.columnModel.getColumn(0).setMaxWidth(32);
        this.columnModel.getColumn(0).setMinWidth(32);
    }

    class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -7312387923027032759L;

        RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompoundEdit compound = new CompoundEdit();
            HolidayTable.this.app.getProject().getUndoManager().addEdit(compound);
            try {
                int[] rows;
                int deleted = 0;
                int[] nArray = rows = HolidayTable.this.getSelectedRows();
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    HolidayTable.this.app.getProject().getController().removeAdditionalHoliday(row - deleted);
                    ++deleted;
                    ++n2;
                }
            }
            finally {
                compound.end();
            }
        }
    }
}

