/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.model.ProjectModifiedListener;
import jp.sourceforge.freegantt.data.serializer.FileFormatException;
import jp.sourceforge.freegantt.data.serializer.FtgSerializer;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.persistence.Initialize;
import jp.sourceforge.freegantt.print.GanttChartPrintable;
import jp.sourceforge.freegantt.swing.ApplicationItemMenu;
import jp.sourceforge.freegantt.swing.ApplicationMenu;
import jp.sourceforge.freegantt.swing.ConfigRootPane;
import jp.sourceforge.freegantt.swing.ConfigSplitPane;
import jp.sourceforge.freegantt.swing.GanttChartPane;
import jp.sourceforge.freegantt.swing.HolidayRootPane;
import jp.sourceforge.freegantt.swing.MemberRootPane;
import jp.sourceforge.freegantt.swing.ProjectRootPane;
import jp.sourceforge.freegantt.swing.TaskLineDataPane;
import jp.sourceforge.freegantt.swing.TaskLineHeaderPane;
import jp.sourceforge.freegantt.swing.TaskLineRootPane;
import jp.sourceforge.freegantt.swing.TaskListRootPane;
import jp.sourceforge.freegantt.swing.TaskListTable;
import jp.sourceforge.freegantt.swing.VersionDialog;
import org.xml.sax.SAXException;

public class Application
extends JFrame {
    private static final long serialVersionUID = 1035207996697568561L;
    public static final String TITLE = "FreeGantt";
    public static final String VERSION = "0.0.5";
    public static final String SKELETON_FILE = "skel.fgt";
    public static final int CONFIG_PROJECT = 0;
    public static final int CONFIG_MEMBER = 1;
    public static final int CONFIG_HOLIDAY = 2;
    public static final int CONFIG_MAX = 3;
    Project project;
    ApplicationMenu menuBar;
    Image iconImage = new ImageIcon(this.getClass().getResource("icon.png")).getImage();
    JPanel iconMenuPane;
    ConfigSplitPane configSplitPane;
    GanttChartPane chartPane;
    ConfigRootPane configPane;
    ProjectRootPane projectPane;
    MemberRootPane memberPane;
    HolidayRootPane holidayPane;

    public ApplicationMenu getMenu() {
        return this.menuBar;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public static void main(String[] args) {
        Application app = new Application();
        Resource.makeInstance(app.getLocale());
        Initialize.getInstance().load();
        app.setProject(new Project());
        if (args.length > 0) {
            app.loadData(args[0]);
        } else {
            app.loadSkelton();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.this.initialize();
                Application.this.setDefaultCloseOperation(3);
                Application.this.setSize(Initialize.getInstance().getInt("applicationWidth", 1024), Initialize.getInstance().getInt("applicationHeight", 768));
                Application.this.setBackground(Color.white);
                Application.this.setTitle(Application.TITLE);
                Application.this.addWindowListener(Application.this.createWindowListener());
                Application.this.setIconImage(Application.this.getApplicationIconImage());
            }
        });
    }

    public void newFile() {
        if (this.confirmDiscard()) {
            return;
        }
        this.loadSkelton();
        this.initialize();
    }

    private void initialize() {
        this.setVisible(false);
        this.getProject().getProjectModifiedModel().addProjectModifiedListener(new ProjectModifiedHandler());
        this.project.updateChartRange();
        JOptionPane.setDefaultLocale(Resource.getLocale());
        this.menuBar = new ApplicationMenu(this);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().removeAll();
        this.iconMenuPane = new ApplicationItemMenu(this);
        this.getContentPane().add((Component)this.iconMenuPane, "North");
        this.configSplitPane = new ConfigSplitPane(1);
        this.configSplitPane.setBounds(0, 0, 1, 1);
        this.configSplitPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configSplitPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configSplitPane.setDividerSize(4);
        this.configSplitPane.setContinuousLayout(true);
        this.configSplitPane.setResizeWeight(1.0);
        this.getContentPane().add((Component)this.configSplitPane, "Center");
        this.chartPane = new GanttChartPane(this);
        this.chartPane.setBounds(0, 0, 1, 1);
        this.chartPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.chartPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.chartPane.setLayout(null);
        this.configSplitPane.add(this.chartPane);
        this.configPane = new ConfigRootPane();
        this.configPane.setBounds(0, 0, 1, 1);
        this.configPane.setPreferredSize(new Dimension(0, Integer.MAX_VALUE));
        this.configPane.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.configPane.setMinimumSize(new Dimension(1, 1));
        this.configPane.setTabLayoutPolicy(1);
        this.configSplitPane.add(this.configPane);
        this.projectPane = new ProjectRootPane(this);
        this.projectPane.setBounds(0, 0, 300, 200);
        this.projectPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.projectPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configPane.addTab(Resource.get("tabInfo"), this.projectPane);
        this.memberPane = new MemberRootPane(this);
        this.memberPane.setBounds(0, 0, 300, 200);
        this.memberPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.memberPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configPane.addTab(Resource.get("tabResource"), this.memberPane);
        this.holidayPane = new HolidayRootPane(this);
        this.holidayPane.setBounds(0, 0, 300, 200);
        this.holidayPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.holidayPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configPane.addTab(Resource.get("tabHoliday"), this.holidayPane);
        this.getTaskLineRootPane().initializeViewportOffset();
        this.setVisible(true);
    }

    protected void saveData(String filename) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(filename);
                new FtgSerializer().write(this.project, out);
                out.close();
                this.project.setFilename(filename);
                this.project.setFileLastModified(new File(filename).lastModified());
                this.project.setModified(false);
                this.updateTitle();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, Resource.get("fileIOErrorMessage"), Resource.get("fileIOErrorTitle"), 0);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void updateTitle() {
        StringBuilder builder = new StringBuilder();
        builder.append(TITLE);
        builder.append(this.project.isModified() ? " * " : " ");
        if (this.project.getFilename() != null) {
            builder.append(this.project.getFilename());
        }
        this.setTitle(builder.toString());
    }

    public void saveData() {
        if (this.project.getFilename() == null) {
            this.saveAsData();
        } else {
            File file = new File(this.project.getFilename());
            if (file.lastModified() != this.project.getFileLastModified()) {
                int ret = JOptionPane.showConfirmDialog(this, Resource.get("saveLastModifiedConfirmMessage"), Resource.get("saveLastModifiedConfirmTitle"), 2);
                if (ret == 0) {
                    this.saveData(this.project.getFilename());
                }
            } else {
                this.saveData(this.project.getFilename());
            }
        }
    }

    public void saveAsData() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Resource.get("dialogFileType"), "fgt");
        chooser.setFileFilter(filter);
        int ret = chooser.showSaveDialog(this);
        if (ret == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            if (!filename.endsWith(".fgt")) {
                filename = filename.concat(".fgt");
            }
            this.saveData(filename);
        }
    }

    protected void loadSkelton() {
        if (new File(SKELETON_FILE).exists()) {
            this.loadData(SKELETON_FILE);
            this.project.setFilename(null);
        } else {
            this.project = new Project();
        }
    }

    /*
     * Loose catch block
     */
    protected void loadData(String filename) {
        FileInputStream in = null;
        try {
            try {
                File file = new File(filename);
                in = new FileInputStream(file);
                Project project = new Project();
                new FtgSerializer().read(project, in);
                in.close();
                this.project = project;
                this.project.setFilename(filename);
                this.project.setFileLastModified(file.lastModified());
                this.project.update();
                this.updateTitle();
                this.initialize();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "FreeGantt\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (SAXException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "FreeGantt\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (FileFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "FreeGantt\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean confirmDiscard() {
        if (!this.project.isModified()) {
            return false;
        }
        int ret = JOptionPane.showConfirmDialog(this, Resource.get("loadModifiedConfirmMessage"), Resource.get("loadModifiedConfirmTitle"), 2);
        return ret == 2;
    }

    public void loadData() {
        if (this.confirmDiscard()) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Resource.get("dialogFileType"), "fgt");
        chooser.setFileFilter(filter);
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.loadData(filename);
        }
    }

    public Image getApplicationIconImage() {
        return this.iconImage;
    }

    public TaskLineDataPane getTaskLineDataPane() {
        if (this.chartPane == null || this.chartPane.getTaskLineRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskLineRootPane().getTaskLineDataPane();
    }

    public JViewport getDataViewport() {
        if (this.chartPane == null || this.chartPane.getTaskLineRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskLineRootPane().getDataViewport();
    }

    public TaskListTable getTaskListTable() {
        if (this.chartPane == null || this.chartPane.getTaskListRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskListRootPane().getTaskListTable();
    }

    public TaskListRootPane getTaskListRootPane() {
        if (this.chartPane == null) {
            return null;
        }
        return this.chartPane.getTaskListRootPane();
    }

    public GanttChartPane getGanttChartPane() {
        return this.chartPane;
    }

    public TaskLineRootPane getTaskLineRootPane() {
        return this.chartPane.getTaskLineRootPane();
    }

    public TaskLineHeaderPane getTaskLineHeaderPane() {
        if (this.chartPane == null || this.chartPane.getTaskListRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskLineRootPane().getTaskLineHeaderPane();
    }

    public void openConfig(int type) {
        this.configPane.setSelectedIndex(type);
        int location = this.configSplitPane.getWidth() - 200;
        this.configSplitPane.setDividerLocation(location);
    }

    public void updateLocale(Locale locale) {
        this.setLocale(locale);
        Resource.makeInstance(this.getLocale());
        this.project.updateTableModel();
        this.initialize();
    }

    public void configurePage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat = printerJob.pageDialog(this.getProject().getPrint().getPageFormat());
        this.project.getController().setPageFormat(this.project, pageFormat);
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        GanttChartPrintable printable = new GanttChartPrintable(this);
        job.setPrintable(printable, this.getProject().getPrint().getPageFormat());
        job.setPageable(printable);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void changeCalendarMode() {
        int mode = this.project.isCalendarModeDate() ? 1 : 0;
        this.project.setCalendarMode(mode);
        Dimension dim = this.project.getCellSize();
        dim.width = mode == 0 ? (dim.width *= 2) : dim.width / 4 * 2;
        this.project.getTaskTableModel().fireTableChanged();
        this.getTaskLineRootPane().updateChartRange();
    }

    public WindowListener createWindowListener() {
        return new AppWindowListener();
    }

    public void savePreference() {
        Initialize.getInstance().putValue("applicationWidth", this.getWidth());
        Initialize.getInstance().putValue("applicationHeight", this.getHeight());
        Initialize.getInstance().save();
    }

    public void openVersionDialog() {
        VersionDialog dialog = new VersionDialog(this);
        dialog.setVisible(true);
    }

    public void openHelpDocument() {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(Resource.get("helpDocumentURL")));
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public void openSiteRoot() {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(Resource.get("siteRootURL")));
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    class AppWindowListener
    implements WindowListener {
        AppWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Application.this.savePreference();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }

    public class ProjectModifiedHandler
    implements ProjectModifiedListener {
        @Override
        public void projectModified() {
            Application.this.updateTitle();
        }
    }
}

