/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import java.util.Calendar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;

public class UpdateAdditionalHolidayEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 764441346885765481L;
    Project project;
    Calendar newCalendar;
    Calendar oldCalendar;
    int row;

    public UpdateAdditionalHolidayEdit(Project project, Calendar calendar, int row) {
        this.project = project;
        this.newCalendar = (Calendar)calendar.clone();
        this.oldCalendar = project.getAdditionalHolidays().get(row);
        this.row = row;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.project.getController().setAdditionalHoliday(this.oldCalendar, this.row);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().setAdditionalHoliday(this.newCalendar, this.row);
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.newCalendar = null;
        this.oldCalendar = null;
    }
}

