/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class TaskNameCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -1820480136651683438L;
    public static final int INDENT_WIDTH = 16;
    JTable table;
    Component component;
    Project project;
    Task task;
    Image foldClosedImage;
    Image foldOpenedImage;
    FoldBorder foldBorder;

    public TaskNameCellRenderer(Project project) {
        this.project = project;
        this.foldClosedImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("fold_closed.png"));
        this.foldOpenedImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("fold_opened.png"));
        this.foldBorder = new FoldBorder(new Insets(1, 1, 1, 1));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.table = table;
        this.component = component;
        this.task = this.project.getTaskAtRow(row);
        if (this.task == null) {
            return component;
        }
        this.setBorder(this.foldBorder);
        return component;
    }

    class FoldBorder
    implements Border {
        Insets insets;

        public FoldBorder(Insets insets) {
            this.insets = insets;
        }

        public Rectangle getFoldRect() {
            if (!TaskNameCellRenderer.this.task.isParent()) {
                return null;
            }
            int offsetLeft = this.getBorderInsets((Component)TaskNameCellRenderer.this.component).left;
            return new Rectangle(offsetLeft - TaskNameCellRenderer.this.foldOpenedImage.getWidth(null) - 3, 3, TaskNameCellRenderer.this.foldOpenedImage.getWidth(null), TaskNameCellRenderer.this.foldOpenedImage.getHeight(null));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle foldRect = this.getFoldRect();
            if (foldRect != null) {
                g.drawImage(TaskNameCellRenderer.this.task.isOpened() ? TaskNameCellRenderer.this.foldOpenedImage : TaskNameCellRenderer.this.foldClosedImage, foldRect.x, foldRect.y, TaskNameCellRenderer.this.table);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets result = (Insets)this.insets.clone();
            if (TaskNameCellRenderer.this.task.isParent()) {
                result.left += 15;
            }
            result.left += (TaskNameCellRenderer.this.project.getMaxLevel() - TaskNameCellRenderer.this.task.getLevel()) * 16;
            return result;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

