/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.undo.CompoundEdit;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.print.PreviewDialog;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskListTable;

public class ApplicationMenu
extends JMenuBar {
    private static final long serialVersionUID = -8682706642684252609L;
    Application app;
    UndoAction undoAction;
    RedoAction redoAction;
    CutAction cutAction;
    CopyAction copyAction;
    PasteAction pasteAction;
    JMenuItem editUndo;
    JMenuItem editRedo;
    JMenuItem editCut;
    JMenuItem editCopy;
    JMenuItem editPaste;

    public UndoAction getUndoAction() {
        return this.undoAction;
    }

    public RedoAction getRedoAction() {
        return this.redoAction;
    }

    public CutAction getCutAction() {
        return this.cutAction;
    }

    public CopyAction getCopyAction() {
        return this.copyAction;
    }

    public PasteAction getPasteAction() {
        return this.pasteAction;
    }

    public ApplicationMenu(final Application app) {
        this.app = app;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.cutAction = new CutAction();
        this.copyAction = new CopyAction();
        this.pasteAction = new PasteAction();
        Font font = this.getFont();
        Font newFont = new Font(font.getName(), 0, font.getSize());
        UIManager.put("Menu.font", newFont);
        UIManager.put("MenuItem.font", newFont);
        UIManager.put("MenuItem.acceleratorFont", newFont);
        UIManager.put("MenuItem.acceleratorForeground", Color.gray);
        JMenu menu = new JMenu(Resource.get("menuFile"));
        JMenuItem item = new JMenuItem(Resource.get("menuFileNew"));
        item.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.newFile();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileOpen"));
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.loadData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSave"));
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.saveData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSaveAs"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.saveAsData();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Resource.get("menuFilePreview"));
        item.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog dialog = new PreviewDialog(app);
                dialog.setVisible(true);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFilePage"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.configurePage();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFilePrint"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.print();
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuEdit"));
        menu.addMenuListener(new EditPopupListener());
        item = new JMenuItem(Resource.get("menuEditUndo"));
        item.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        item.addActionListener(this.undoAction);
        menu.add(item);
        this.editUndo = item;
        item = new JMenuItem(Resource.get("menuEditRedo"));
        item.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        item.addActionListener(this.redoAction);
        menu.add(item);
        this.editRedo = item;
        menu.addSeparator();
        item = new JMenuItem(Resource.get("menuEditCut"));
        item.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        item.addActionListener(this.cutAction);
        menu.add(item);
        this.editCut = item;
        item = new JMenuItem(Resource.get("menuEditCopy"));
        item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        item.addActionListener(this.copyAction);
        menu.add(item);
        this.editCopy = item;
        item = new JMenuItem(Resource.get("menuEditPaste"));
        item.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        item.addActionListener(this.pasteAction);
        menu.add(item);
        this.editPaste = item;
        this.add(menu);
        menu = new JMenu(Resource.get("menuView"));
        item = new JMenuItem(Resource.get("menuViewCalendarMode"));
        item.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.changeCalendarMode();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuViewProgress"));
        item.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.getTaskLineDataPane().setProgressLineMode(!app.getTaskLineDataPane().isProgressLineMode());
                app.getTaskLineDataPane().repaint();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuViewPage"));
        item.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.getTaskLineDataPane().setPrintRangeMode(!app.getTaskLineDataPane().isPrintRangeMode());
                app.getTaskLineDataPane().repaint();
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuWindow"));
        item = new JMenuItem(Resource.get("menuWindowInfo"));
        item.setAccelerator(KeyStroke.getKeyStroke(73, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(0);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuWindowResource"));
        item.setAccelerator(KeyStroke.getKeyStroke(82, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(1);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuWindowHoliday"));
        item.setAccelerator(KeyStroke.getKeyStroke(72, 3));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openConfig(2);
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuLang"));
        item = new JMenuItem(Resource.get("menuLangEn"));
        item.setEnabled(!app.getLocale().getLanguage().equals(Locale.ENGLISH.getLanguage()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.updateLocale(Locale.ENGLISH);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuLangJp"));
        item.setEnabled(!app.getLocale().getLanguage().equals(Locale.JAPANESE.getLanguage()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.updateLocale(Locale.JAPANESE);
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuHelp"));
        item = new JMenuItem(Resource.get("menuHelpDocument"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openHelpDocument();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuHelpVersion"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.openVersionDialog();
            }
        });
        menu.add(item);
        this.add(menu);
    }

    class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = 318323821561167362L;

        CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskListTable table = ApplicationMenu.this.app.getTaskListTable();
            if (table == null) {
                return;
            }
            table.copySelectedToClipboard();
        }
    }

    class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1046831944357988605L;

        CutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskListTable table = ApplicationMenu.this.app.getTaskListTable();
            if (table == null) {
                return;
            }
            table.copySelectedToClipboard();
            CompoundEdit compound = new CompoundEdit();
            ApplicationMenu.this.app.getProject().getUndoManager().addEdit(compound);
            table.removeSelectedRows();
            compound.end();
        }
    }

    class EditPopupListener
    implements MenuListener {
        EditPopupListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            ApplicationMenu.this.editUndo.setEnabled(ApplicationMenu.this.app.getProject().getUndoManager().canUndo());
            ApplicationMenu.this.editRedo.setEnabled(ApplicationMenu.this.app.getProject().getUndoManager().canRedo());
            TaskListTable table = ApplicationMenu.this.app.getTaskListTable();
            if (table == null) {
                return;
            }
            ApplicationMenu.this.editCut.setEnabled(table.getSelectedRows().length > 0);
            ApplicationMenu.this.editCopy.setEnabled(table.getSelectedRows().length > 0);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            ApplicationMenu.this.editUndo.setEnabled(true);
            ApplicationMenu.this.editRedo.setEnabled(true);
            ApplicationMenu.this.editCut.setEnabled(true);
            ApplicationMenu.this.editCopy.setEnabled(true);
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            ApplicationMenu.this.editUndo.setEnabled(true);
            ApplicationMenu.this.editRedo.setEnabled(true);
            ApplicationMenu.this.editCut.setEnabled(true);
            ApplicationMenu.this.editCopy.setEnabled(true);
        }
    }

    class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = 3415153071727519882L;

        PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskListTable table = ApplicationMenu.this.app.getTaskListTable();
            if (table == null) {
                return;
            }
            CompoundEdit compound = new CompoundEdit();
            ApplicationMenu.this.app.getProject().getUndoManager().addEdit(compound);
            try {
                table.pasteFromClipboard();
            }
            catch (UnsupportedFlavorException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            compound.end();
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -5980994835631840346L;

        RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ApplicationMenu.this.app.getProject().getUndoManager().canRedo()) {
                ApplicationMenu.this.app.getProject().getUndoManager().redo();
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2191070476189083744L;

        UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ApplicationMenu.this.app.getProject().getUndoManager().canUndo()) {
                ApplicationMenu.this.app.getProject().getUndoManager().undo();
            }
        }
    }
}

